/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.entity.ChickenCoopBlockEntity;
import net.satisfy.farm_and_charm.core.entity.ChickenCoopAccess;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;

public class ChickenGotoAndEnterCoopGoal
extends Goal {
    private final Chicken chicken;

    public ChickenGotoAndEnterCoopGoal(Chicken chicken) {
        this.chicken = chicken;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        ChickenCoopBlockEntity coop;
        if (((ChickenCoopAccess)this.chicken).farmAndCharm$getCoopCooldown() > 0) {
            return false;
        }
        if (!((ChickenCoopAccess)this.chicken).farmAndCharm$hasCoopTarget()) {
            return false;
        }
        BlockPos target = ((ChickenCoopAccess)this.chicken).farmAndCharm$getCoopTarget();
        if (!this.chicken.level().getBlockState(target).is((Block)ObjectRegistry.CHICKEN_COOP.get())) {
            return false;
        }
        BlockEntity be = this.chicken.level().getBlockEntity(target);
        return be instanceof ChickenCoopBlockEntity && (coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken() && !coop.containsChicken(this.chicken);
    }

    private void tryEnterCoop(BlockPos coopPos) {
        double distance = this.chicken.position().distanceTo(Vec3.atCenterOf((Vec3i)coopPos));
        if (distance <= 1.2) {
            ChickenCoopBlockEntity coop;
            BlockEntity be = this.chicken.level().getBlockEntity(coopPos);
            if (be instanceof ChickenCoopBlockEntity && (coop = (ChickenCoopBlockEntity)be).hasSpaceForChicken()) {
                this.chicken.level().playSound(null, this.chicken.blockPosition(), SoundEvents.BEEHIVE_ENTER, this.chicken.getSoundSource(), 1.0f, 1.0f);
                coop.addChicken(this.chicken);
                ((ChickenCoopAccess)this.chicken).farmAndCharm$clearCoopTarget();
                ((ChickenCoopAccess)this.chicken).farmAndCharm$setCoopCooldown(1200 * (3 + this.chicken.getRandom().nextInt(10)));
                this.chicken.getNavigation().stop();
            }
        } else if (!this.chicken.getNavigation().isInProgress()) {
            this.chicken.getNavigation().moveTo((double)coopPos.getX() + 0.5, (double)coopPos.getY() + 0.5, (double)coopPos.getZ() + 0.5, 1.0);
        }
    }

    public void start() {
        BlockPos coopPos = ((ChickenCoopAccess)this.chicken).farmAndCharm$getCoopTarget();
        if (coopPos != null) {
            this.tryEnterCoop(coopPos);
        }
    }

    public void tick() {
        BlockPos coopPos = ((ChickenCoopAccess)this.chicken).farmAndCharm$getCoopTarget();
        if (coopPos == null) {
            return;
        }
        if (!this.chicken.level().getBlockState(coopPos).is((Block)ObjectRegistry.CHICKEN_COOP.get())) {
            ((ChickenCoopAccess)this.chicken).farmAndCharm$clearCoopTarget();
            this.chicken.getNavigation().stop();
            return;
        }
        this.tryEnterCoop(coopPos);
    }

    public void stop() {
        this.chicken.getNavigation().stop();
    }
}

