/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;

public class ChickenCoopBlockItem
extends BlockItem {
    public ChickenCoopBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean isFoil(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        return data != null && !data.copyTag().isEmpty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data == null) {
            return;
        }
        CompoundTag tag = data.copyTag();
        int eggCount = tag.getInt("EggCount");
        ListTag chickens = tag.getList("Chickens", 10);
        boolean added = false;
        if (!chickens.isEmpty()) {
            tooltip.add((Component)Component.empty());
            added = true;
            tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.chickencoop_chickens", (Object[])new Object[]{chickens.size(), 3}).withStyle(ChatFormatting.GRAY));
        }
        if (eggCount > 0) {
            if (!added) {
                tooltip.add((Component)Component.empty());
            }
            tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.chickencoop_eggs", (Object[])new Object[]{eggCount, 9}).withStyle(ChatFormatting.GRAY));
        }
    }
}

