/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems;

import java.util.HashMap;
import java.util.Map;
import me.ferdz.placeableitems.init.PlaceableItemsBlockRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final PlaceableItemConfigs PLACEABLE_ITEMS = new PlaceableItemConfigs(BUILDER);
    static final ModConfigSpec SPEC = BUILDER.build();

    public static class PlaceableItemConfigs {
        private final Map<String, ModConfigSpec.BooleanValue> itemToggles = new HashMap<String, ModConfigSpec.BooleanValue>();

        public PlaceableItemConfigs(ModConfigSpec.Builder builder) {
            builder.push("items_toggle");
            for (String itemId : PlaceableItemsBlockRegistry.ALL_PLACEABLE_ITEM_IDS) {
                if (itemId.equals("music_disc")) {
                    String configKey = "enable_placeable_music_disc";
                    ModConfigSpec.BooleanValue configValue = builder.define(configKey, true);
                    this.itemToggles.put(itemId, configValue);
                    continue;
                }
                String mcItemId = itemId;
                if (itemId.equals("gold_ingo")) {
                    mcItemId = "gold_ingot";
                } else if (itemId.equals("writable_boo")) {
                    mcItemId = "writable_book";
                }
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)mcItemId));
                String itemTranslationKey = item.getDescriptionId();
                String configKey = "enable_placeable_" + itemId.replace("_", "");
                ModConfigSpec.BooleanValue configValue = builder.translation(itemTranslationKey).define(configKey, true);
                this.itemToggles.put(itemId, configValue);
            }
            builder.pop();
        }

        public boolean isPlaceableEnabled(String itemId) {
            ModConfigSpec.BooleanValue toggle = this.itemToggles.get(itemId);
            if (itemId.contains("music_disc")) {
                toggle = this.itemToggles.get("music_disc");
            }
            if (toggle == null) {
                if (itemId.equals("gold_ingot")) {
                    toggle = this.itemToggles.get("gold_ingo");
                } else if (itemId.equals("writable_book")) {
                    toggle = this.itemToggles.get("writable_boo");
                }
            }
            return toggle != null ? (Boolean)toggle.get() : true;
        }
    }
}

