/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems;

import com.mojang.logging.LogUtils;
import me.ferdz.placeableitems.Config;
import me.ferdz.placeableitems.datagen.PlaceableItemsBlockStateProvider;
import me.ferdz.placeableitems.datagen.PlaceableItemsRecipeProvider;
import me.ferdz.placeableitems.event.ItemPlaceHandler;
import me.ferdz.placeableitems.init.PlaceableItemsBlockEntityTypeRegistry;
import me.ferdz.placeableitems.init.PlaceableItemsBlockRegistry;
import me.ferdz.placeableitems.init.PlaceableItemsItemsRegistry;
import me.ferdz.placeableitems.network.NetworkHandler;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.slf4j.Logger;

@Mod(value="placeableitems")
public class PlaceableItems {
    public static final String MODID = "placeableitems";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PlaceableItems(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::onRegisterPayloads);
        PlaceableItemsBlockRegistry.BLOCKS.register(modEventBus);
        PlaceableItemsItemsRegistry.ITEMS.register(modEventBus);
        PlaceableItemsBlockEntityTypeRegistry.BLOCK_ENTITY_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(ItemPlaceHandler.class);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        NetworkHandler.register(event);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new PlaceableItemsBlockStateProvider(output, MODID, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new PlaceableItemsRecipeProvider(output, event.getLookupProvider()));
    }
}

