/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import me.ferdz.placeableitems.block.RotationBlock;
import me.ferdz.placeableitems.block.blockentity.StackHolderBlockEntity;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.block.component.IBlockComponent;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PlaceableItemsBlock
extends RotationBlock
implements EntityBlock {
    private VoxelShape shape;
    private List<IBlockComponent> components = new ArrayList<IBlockComponent>();

    public PlaceableItemsBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean hadAnImplementation = false;
        for (IBlockComponent component : this.components) {
            try {
                component.useItemOn(stack, state, level, pos, player, hand, hitResult);
                hadAnImplementation = true;
            }
            catch (AbstractBlockComponent.NotImplementedException notImplementedException) {}
        }
        if (!hadAnImplementation) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        boolean hadAnImplementation = false;
        for (IBlockComponent component : this.components) {
            try {
                component.updateEntityAfterFallOn(worldIn, entityIn);
                hadAnImplementation = true;
            }
            catch (AbstractBlockComponent.NotImplementedException notImplementedException) {}
        }
        if (!hadAnImplementation) {
            super.updateEntityAfterFallOn(worldIn, entityIn);
        }
    }

    public void fallOn(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        boolean hadAnImplementation = false;
        for (IBlockComponent component : this.components) {
            try {
                component.fallOn(worldIn, state, pos, entityIn, fallDistance);
                hadAnImplementation = true;
            }
            catch (AbstractBlockComponent.NotImplementedException notImplementedException) {}
        }
        if (!hadAnImplementation) {
            super.fallOn(worldIn, state, pos, entityIn, fallDistance);
        }
    }

    public void setShape(VoxelShape shape) {
        this.shape = shape;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        for (IBlockComponent component : this.components) {
            VoxelShape shape = component.getShape(this.shape, state, level, pos, context);
            if (shape == null) continue;
            return shape;
        }
        return this.shape;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        for (IBlockComponent component : this.components) {
            blockState = component.getStateForPlacement(context, blockState);
        }
        return blockState;
    }

    PlaceableItemsBlock addComponents(Iterable<IBlockComponent> components) {
        for (IBlockComponent component : components) {
            this.components.add(component);
        }
        return this;
    }

    public List<IBlockComponent> getComponents() {
        return this.components;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new StackHolderBlockEntity(blockPos, blockState);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StackHolderBlockEntity) {
            StackHolderBlockEntity blockEntity2 = (StackHolderBlockEntity)blockEntity;
            blockEntity2.setTheItem(stack.copyWithCount(1));
        }
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof StackHolderBlockEntity) {
            StackHolderBlockEntity blockEntity = (StackHolderBlockEntity)((Object)object);
            return List.of(blockEntity.getTheItem());
        }
        return List.of();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StackHolderBlockEntity) {
            StackHolderBlockEntity blockEntity2 = (StackHolderBlockEntity)blockEntity;
            return blockEntity2.getTheItem();
        }
        return ItemStack.EMPTY;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        this.components.forEach(component -> component.animateTick(state, level, pos, random));
    }
}

