/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import java.util.ArrayList;
import java.util.List;
import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.block.component.IBlockComponent;
import me.ferdz.placeableitems.init.PlaceableItemsBlockRegistry;
import me.ferdz.placeableitems.init.PlaceableItemsMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;

public class PlaceableItemsBlockBuilder {
    private VoxelShape shape;
    private List<IBlockComponent> components = new ArrayList<IBlockComponent>();
    private int lightLevel;

    public static PlaceableItemsBlockBuilder of() {
        return new PlaceableItemsBlockBuilder();
    }

    public PlaceableItemsBlockBuilder setShape(VoxelShape shape) {
        this.shape = shape;
        return this;
    }

    public PlaceableItemsBlockBuilder addComponent(IBlockComponent component) {
        this.components.add(component);
        return this;
    }

    public PlaceableItemsBlockBuilder setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
        return this;
    }

    public DeferredBlock<PlaceableItemsBlock> register(String name, Item ... items) {
        PlaceableItemsBlockRegistry.ALL_PLACEABLE_ITEM_IDS.add(name);
        return PlaceableItemsBlockRegistry.BLOCKS.register(name, () -> {
            PlaceableItemsBlock block = new PlaceableItemsBlock(BlockBehaviour.Properties.of().noOcclusion().lightLevel(state -> this.lightLevel).isViewBlocking((state, worlds, pos) -> false).isSuffocating((state, world, pos) -> false).isRedstoneConductor((state, world, pos) -> false)){

                @Override
                protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
                    super.createBlockStateDefinition(builder);
                    for (IBlockComponent component : PlaceableItemsBlockBuilder.this.components) {
                        component.createBlockStateDefinition(builder);
                    }
                }
            };
            if (this.shape != null) {
                block.setShape(this.shape);
            }
            block.addComponents(this.components);
            for (Item item : items) {
                PlaceableItemsMap.instance().put(item, block);
            }
            return block;
        });
    }
}

