/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.blockentity;

import javax.annotation.ParametersAreNonnullByDefault;
import me.ferdz.placeableitems.init.PlaceableItemsBlockEntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.ContainerSingleItem;

@ParametersAreNonnullByDefault
public class StackHolderBlockEntity
extends BlockEntity
implements ContainerSingleItem.BlockContainerSingleItem {
    private ItemStack itemStack;

    public StackHolderBlockEntity(BlockPos pos, BlockState blockState) {
        super(PlaceableItemsBlockEntityTypeRegistry.STACK_HOLDER.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.itemStack != null && !this.itemStack.isEmpty()) {
            tag.put("PlaceableItems-Stack", this.itemStack.save(registries, (Tag)new CompoundTag()));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("PlaceableItems-Stack")).ifPresent(itemStack -> {
            this.itemStack = itemStack;
        });
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.loadAdditional(tag, lookupProvider);
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public ItemStack getTheItem() {
        if (this.itemStack == null) {
            return ItemStack.EMPTY;
        }
        return this.itemStack;
    }

    public void setTheItem(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.setChanged();
    }
}

