/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.block.blockentity.StackHolderBlockEntity;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import me.ferdz.placeableitems.init.PlaceableItemsMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredBlock;

public class EdibleBlockComponent
extends AbstractBlockComponent {
    private final DeferredBlock<PlaceableItemsBlock> replacesWithBlock;

    public EdibleBlockComponent() {
        this(null);
    }

    public EdibleBlockComponent(DeferredBlock<PlaceableItemsBlock> replacesWithBlock) {
        this.replacesWithBlock = replacesWithBlock;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) throws AbstractBlockComponent.NotImplementedException {
        if (!(state.getBlock() instanceof PlaceableItemsBlock)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StackHolderBlockEntity) {
            StackHolderBlockEntity blockEntity2 = (StackHolderBlockEntity)blockEntity;
            Item item = blockEntity2.getTheItem().getItem();
            FoodProperties food = item.getFoodProperties(new ItemStack((ItemLike)item), (LivingEntity)player);
            if (food == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ItemStack itemStack = new ItemStack((ItemLike)item);
            if (player.canEat(food.canAlwaysEat()) || player.isCreative()) {
                itemStack.finishUsingItem(level, (LivingEntity)player);
                player.eat(level, itemStack);
                state.onDestroyedByPlayer(level, pos, player, false, level.getFluidState(pos));
                if (this.replacesWithBlock != null) {
                    PlaceableItemsBlock replacingBlock = (PlaceableItemsBlock)((Object)this.replacesWithBlock.get());
                    BlockState replacementBlockState = (BlockState)replacingBlock.defaultBlockState().setValue((Property)PlaceableItemsBlock.ROTATION, (Comparable)((Integer)state.getValue((Property)PlaceableItemsBlock.ROTATION)));
                    level.setBlockAndUpdate(pos, replacementBlockState);
                    replacingBlock.setPlacedBy(level, pos, state, (LivingEntity)player, new ItemStack((ItemLike)PlaceableItemsMap.instance().getItemForBlock(replacingBlock)));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public MutableComponent getDescription(ItemStack itemStack) {
        return Component.translatable((String)"key.placeableitems.component.edible");
    }
}

