/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import me.ferdz.placeableitems.block.blockentity.StackHolderBlockEntity;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EnchantedBlockComponent
extends AbstractBlockComponent {
    private boolean alwaysAnimated;

    public EnchantedBlockComponent() {
        this.alwaysAnimated = false;
    }

    public EnchantedBlockComponent(boolean alwaysAnimated) {
        this.alwaysAnimated = alwaysAnimated;
    }

    @Override
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource random) {
        StackHolderBlockEntity stackHolder;
        ItemStack itemStack;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof StackHolderBlockEntity && (itemStack = (stackHolder = (StackHolderBlockEntity)blockEntity).getTheItem()) != null && !itemStack.isEmpty() && (itemStack.isEnchanted() || this.alwaysAnimated)) {
            double d2;
            double d1;
            double d0;
            if (random.nextInt(3) == 0) {
                d0 = (double)pos.getX() + 0.2 + random.nextDouble() * 0.5;
                d1 = (double)pos.getY() + 0.2 + random.nextDouble() * 0.1;
                d2 = (double)pos.getZ() + 0.2 + random.nextDouble() * 0.5;
                worldIn.addParticle((ParticleOptions)ParticleTypes.ENCHANT, d0, d1, d2, (double)random.nextFloat() - 0.5, (double)random.nextFloat() * 0.5, (double)random.nextFloat() - 0.5);
            }
            if (random.nextInt(12) == 0) {
                d0 = (double)pos.getX() + 0.2 + random.nextDouble() * 0.5;
                d1 = (double)pos.getY() + 0.2 + random.nextDouble() * 0.1;
                d2 = (double)pos.getZ() + 0.2 + random.nextDouble() * 0.5;
                worldIn.addParticle((ParticleOptions)ParticleTypes.GLOW, d0, d1, d2, 0.3, 0.3, 0.3);
            }
        }
    }
}

