/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ItemStackSourceBlockComponent
extends AbstractBlockComponent {
    private final float chance;
    private final Supplier<ItemStack> itemSupplier;

    public ItemStackSourceBlockComponent(float chance, Supplier<ItemStack> itemSupplier) {
        Preconditions.checkArgument((itemSupplier != null ? 1 : 0) != 0, (Object)"Item supplier must not be null");
        this.chance = chance;
        this.itemSupplier = itemSupplier;
    }

    public ItemStackSourceBlockComponent(Supplier<ItemStack> itemSupplier) {
        this(1.0f, itemSupplier);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) throws AbstractBlockComponent.NotImplementedException {
        ItemStack droppedStack;
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (level.random.nextFloat() < this.chance && (droppedStack = this.itemSupplier.get()) != null && !droppedStack.isEmpty()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)droppedStack);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

