/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MultiModelBlockComponent
extends AbstractBlockComponent {
    private final int maxCount;
    public final IntegerProperty model;

    public MultiModelBlockComponent(int maxCount) {
        this.maxCount = maxCount;
        this.model = IntegerProperty.create((String)"model", (int)0, (int)maxCount);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) throws AbstractBlockComponent.NotImplementedException {
        int nextModel = (Integer)state.getValue((Property)this.model) + 1;
        if (nextModel > this.maxCount) {
            nextModel = 0;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.model, (Comparable)Integer.valueOf(nextModel)));
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.model});
    }

    @Override
    public MutableComponent getDescription(ItemStack itemStack) {
        return Component.translatable((String)"key.placeableitems.component.multimodel", (Object[])new Object[]{Component.literal((String)String.valueOf(this.maxCount + 1))});
    }
}

