/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block.component.impl;

import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.block.blockentity.StackHolderBlockEntity;
import me.ferdz.placeableitems.block.component.AbstractBlockComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class StackableBlockComponent
extends AbstractBlockComponent {
    public final int maxCount;
    public final IntegerProperty filled;

    public StackableBlockComponent(int maxCount) {
        this.maxCount = maxCount;
        this.filled = IntegerProperty.create((String)"count", (int)1, (int)maxCount);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) throws AbstractBlockComponent.NotImplementedException {
        Block block = state.getBlock();
        if (!(block instanceof PlaceableItemsBlock)) {
            return super.useItemOn(heldStack, state, level, pos, player, hand, hitResult);
        }
        PlaceableItemsBlock block2 = (PlaceableItemsBlock)block;
        int count = (Integer)state.getValue((Property)this.filled);
        StackHolderBlockEntity blockEntity = (StackHolderBlockEntity)level.getBlockEntity(pos);
        Item placedItem = blockEntity.getTheItem().getItem();
        if (heldStack.getItem() == Items.AIR) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)placedItem, 1));
            if (count == 1) {
                level.destroyBlock(pos, false, (Entity)player);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.filled, (Comparable)Integer.valueOf(count - 1)));
                blockEntity.setTheItem(new ItemStack((ItemLike)placedItem, count - 1));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (heldStack.getItem() == placedItem) {
            if (count == this.maxCount) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!player.isCreative()) {
                heldStack.shrink(1);
                blockEntity.setTheItem(new ItemStack((ItemLike)placedItem, count - 1));
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.filled, (Comparable)Integer.valueOf(count + 1)));
            blockEntity.setTheItem(new ItemStack((ItemLike)placedItem, count + 1));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.filled});
    }

    @Override
    public MutableComponent getDescription(ItemStack itemStack) {
        return Component.translatable((String)"key.placeableitems.component.stackable", (Object[])new Object[]{itemStack.getItem().getDescription()});
    }
}

