/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.datagen;

import java.util.Optional;
import me.ferdz.placeableitems.block.component.impl.BiPositionBlockComponent;
import me.ferdz.placeableitems.block.component.impl.MultiModelBlockComponent;
import me.ferdz.placeableitems.block.component.impl.MusicDiscBlockComponent;
import me.ferdz.placeableitems.block.component.impl.StackableBlockComponent;
import me.ferdz.placeableitems.init.PlaceableItemsBlockRegistry;
import me.ferdz.placeableitems.init.PlaceableItemsMap;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class PlaceableItemsBlockStateProvider
extends BlockStateProvider {
    public PlaceableItemsBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        PlaceableItemsMap.instance().forEach((item, block) -> {
            String strippedItemId = item.toString().split(":")[1];
            Optional<BiPositionBlockComponent> biPositionComponent = block.getComponents().stream().filter(component -> component instanceof BiPositionBlockComponent).map(component -> (BiPositionBlockComponent)component).findFirst();
            Optional<MultiModelBlockComponent> multiModelComponent = block.getComponents().stream().filter(component -> component instanceof MultiModelBlockComponent).map(component -> (MultiModelBlockComponent)component).findFirst();
            Optional<MusicDiscBlockComponent> musicDiscComponent = block.getComponents().stream().filter(component -> component instanceof MusicDiscBlockComponent).map(component -> (MusicDiscBlockComponent)component).findFirst();
            Optional<StackableBlockComponent> stackableComponent = block.getComponents().stream().filter(component -> component instanceof StackableBlockComponent).map(component -> (StackableBlockComponent)component).findFirst();
            if (biPositionComponent.isPresent()) {
                this.buildBiPositionVariant(strippedItemId, (Block)block);
            } else if (multiModelComponent.isPresent()) {
                this.buildMultiModelVariant(strippedItemId, (Block)block, multiModelComponent.get());
            } else {
                if (musicDiscComponent.isPresent()) {
                    return;
                }
                if (stackableComponent.isPresent()) {
                    this.buildStackableModelVariant(strippedItemId, (Block)block, stackableComponent.get());
                } else {
                    this.buildSimpleVariant(strippedItemId, (Block)block);
                }
            }
        });
        this.buildMusicDiscModelVariant((Block)PlaceableItemsBlockRegistry.MUSIC_DISC.get());
    }

    private void buildSimpleVariant(String itemId, Block block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc(itemId));
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        VariantBlockStateBuilder.PartialBlockstate partialState = variantBuilder.partialState();
        variantBuilder.addModels(partialState, partialState.modelForState().modelFile((ModelFile)model).build());
    }

    private void buildBiPositionVariant(String itemId, Block block) {
        ModelFile.ExistingModelFile downModel = this.models().getExistingFile(this.modLoc(itemId + "_down"));
        ModelFile.ExistingModelFile upModel = this.models().getExistingFile(this.modLoc(itemId + "_up"));
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)downModel).addModel();
        variantBuilder.partialState().with((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)upModel).addModel();
    }

    private void buildMultiModelVariant(String itemId, Block block, MultiModelBlockComponent component) {
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        int modelCount = component.model.getPossibleValues().stream().mapToInt(Integer::intValue).max().getAsInt();
        for (int i = 0; i <= modelCount; ++i) {
            variantBuilder.partialState().with((Property)component.model, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + itemId + "/" + itemId + "_" + i))).addModel();
        }
    }

    private void buildStackableModelVariant(String itemId, Block block, StackableBlockComponent component) {
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        int modelCount = component.maxCount;
        for (int i = 1; i <= modelCount; ++i) {
            variantBuilder.partialState().with((Property)component.filled, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + itemId + "/" + itemId + "_" + i))).addModel();
        }
    }

    private void buildMusicDiscModelVariant(Block block) {
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        for (MusicDiscBlockComponent.MusicDiscType discType : MusicDiscBlockComponent.MusicDiscType.values()) {
            variantBuilder.partialState().with(MusicDiscBlockComponent.DISC_TYPE, (Comparable)((Object)discType)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/disc/" + discType.getSerializedName()))).addModel();
        }
    }
}

