/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.event;

import me.ferdz.placeableitems.Config;
import me.ferdz.placeableitems.block.PlaceableItemsBlock;
import me.ferdz.placeableitems.init.PlaceableItemsMap;
import me.ferdz.placeableitems.network.ServerKeyState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ItemPlaceHandler {
    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack;
        String itemId;
        Player player = event.getEntity();
        if (!ServerKeyState.isHolding(player.getUUID())) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GameType gameMode = serverPlayer.gameMode.getGameModeForPlayer();
            if (gameMode != GameType.SURVIVAL && gameMode != GameType.CREATIVE) {
                return;
            }
        }
        if (!Config.PLACEABLE_ITEMS.isPlaceableEnabled(itemId = BuiltInRegistries.ITEM.getKey((Object)(itemStack = event.getItemStack()).getItem()).getPath())) {
            return;
        }
        PlaceableItemsBlock block = (PlaceableItemsBlock)((Object)PlaceableItemsMap.instance().get(itemStack.getItem()));
        if (block == null) {
            return;
        }
        BlockPos placePos = event.getPos().relative(event.getFace());
        BlockPlaceContext placeContext = new BlockPlaceContext(new UseOnContext(player, event.getHand(), new BlockHitResult(player.getLookAngle(), event.getFace(), event.getPos(), false)));
        if (!placeContext.canPlace()) {
            return;
        }
        BlockState blockState = block.getStateForPlacement(placeContext);
        if (blockState == null) {
            return;
        }
        Level level = event.getLevel();
        if (!level.isUnobstructed(blockState, placePos, CollisionContext.of((Entity)player))) {
            return;
        }
        if (!level.mayInteract(player, placePos)) {
            return;
        }
        event.getLevel().setBlock(placePos, blockState, 3);
        block.setPlacedBy(event.getLevel(), placePos, blockState, (LivingEntity)player, itemStack);
        if (!player.isCreative()) {
            itemStack.shrink(1);
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

