/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PlaceableItemsDynamicModel
implements IDynamicBakedModel {
    private final BakedModel base;
    private final boolean useAmbientOcclusion;
    private final boolean isGui3d;
    private final TextureAtlasSprite particleIcon;

    public PlaceableItemsDynamicModel(BakedModel base, boolean useAmbientOcclusion, boolean isGui3d, TextureAtlasSprite particleIcon) {
        this.base = base;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.particleIcon = particleIcon;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        List<Object> quads = new ArrayList<BakedQuad>();
        quads.addAll(this.base.getQuads(state, side, rand, extraData, renderType));
        if (state != null && state.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            float angle = (float)((Integer)state.getValue((Property)BlockStateProperties.ROTATION_16)).intValue() * -22.5f;
            Transformation tm = new Transformation(null, Axis.YP.rotationDegrees(angle), null, null);
            tm = tm.blockCenterToCorner();
            quads = QuadTransformers.applying((Transformation)tm).process(quads);
        }
        return quads;
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.base.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particleIcon;
    }

    public ItemOverrides getOverrides() {
        return null;
    }
}

