/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.hearth_and_timber.core.registry.ObjectRegistry;

public interface IRubbleMasonry {
    public Supplier<Block> getNextBlock();

    public Supplier<Block> getPreviousBlock();

    default public ItemInteractionResult handleInteraction(BlockState blockState, Level level, BlockPos position, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.is(Items.IRON_PICKAXE) || heldStack.is(Items.STONE_PICKAXE) || heldStack.is(Items.DIAMOND_PICKAXE) || heldStack.is(Items.NETHERITE_PICKAXE) || heldStack.is(Items.GOLDEN_PICKAXE)) {
            Block nextBlock;
            Block block = nextBlock = this.getNextBlock() == null ? null : this.getNextBlock().get();
            if (nextBlock != null) {
                if (!level.isClientSide) {
                    level.setBlock(position, IRubbleMasonry.copyMatching(blockState, nextBlock.defaultBlockState()), 3);
                }
                player.swing(hand);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (heldStack.is(((Block)ObjectRegistry.QUICKLIME.get()).asItem())) {
            Block previousBlock;
            Block block = previousBlock = this.getPreviousBlock() == null ? null : this.getPreviousBlock().get();
            if (previousBlock != null) {
                BlockState targetState = IRubbleMasonry.copyMatching(blockState, previousBlock.defaultBlockState());
                if (!level.isClientSide) {
                    level.setBlock(position, targetState, 3);
                    if (!player.getAbilities().instabuild) {
                        heldStack.shrink(1);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            tooltipList.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        tooltipList.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.rubble.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        tooltipList.add((Component)Component.empty());
        tooltipList.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.rubble.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }

    public static BlockState copyMatching(BlockState fromState, BlockState toState) {
        for (Property property : toState.getProperties()) {
            if (!fromState.hasProperty(property)) continue;
            toState = IRubbleMasonry.setUnchecked(toState, property, fromState.getValue(property));
        }
        return toState;
    }

    public static <T extends Comparable<T>> BlockState setUnchecked(BlockState state, Property<T> property, Object value) {
        return (BlockState)state.setValue(property, (Comparable)property.getValueClass().cast(value));
    }
}

