/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.hearth_and_timber.core.registry.ObjectRegistry;

public interface IWeatheringThatch {
    public Supplier<Block> getNextBlock();

    default public void tickWeathering(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState next;
        if (random.nextInt(18000) == 0 && (next = this.getNextState(state)) != null) {
            level.setBlock(pos, next, 2);
        }
    }

    default public BlockState getNextState(BlockState current) {
        Block next = this.getNextBlock() == null ? null : this.getNextBlock().get();
        return next == null ? null : IWeatheringThatch.copyMatching(current, next.defaultBlockState());
    }

    default public ItemInteractionResult handleInteraction(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        boolean isWaterBottle;
        ItemStack stack = player.getItemInHand(hand);
        PotionContents potionData = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        Optional optionalPotion = potionData == null ? Optional.empty() : potionData.potion();
        boolean bl = isWaterBottle = optionalPotion.isPresent() && ((Holder)optionalPotion.get()).is(Potions.WATER);
        if (isWaterBottle) {
            Block next;
            Block block = next = this.getNextBlock() == null ? null : this.getNextBlock().get();
            if (next != null) {
                BlockState target = IWeatheringThatch.copyMatching(state, next.defaultBlockState());
                if (!level.isClientSide) {
                    level.setBlock(pos, target, 2);
                    stack.shrink(1);
                    player.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(Items.WHEAT)) {
            Block base = (Block)ObjectRegistry.THATCH.get();
            if (base != null) {
                BlockState target = IWeatheringThatch.copyMatching(state, base.defaultBlockState());
                if (!level.isClientSide) {
                    level.setBlock(pos, target, 2);
                    stack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() instanceof HoeItem) {
            Block current = state.getBlock();
            Block previous = IWeatheringThatch.getPrevious(current);
            if (previous != null) {
                BlockState target = IWeatheringThatch.copyMatching(state, previous.defaultBlockState());
                if (!level.isClientSide) {
                    level.setBlock(pos, target, 2);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static BlockState copyMatching(BlockState from, BlockState to) {
        for (Property property : to.getProperties()) {
            if (!from.hasProperty(property)) continue;
            to = IWeatheringThatch.setUnchecked(to, property, from.getValue(property));
        }
        return to;
    }

    private static <T extends Comparable<T>> BlockState setUnchecked(BlockState state, Property<T> property, Object value) {
        return (BlockState)state.setValue(property, (Comparable)property.getValueClass().cast(value));
    }

    private static Block getPrevious(Block block) {
        if (block == ObjectRegistry.WEATHERED_THATCH.get()) {
            return (Block)ObjectRegistry.THATCH.get();
        }
        if (block == ObjectRegistry.DRYING_THATCH.get()) {
            return (Block)ObjectRegistry.WEATHERED_THATCH.get();
        }
        if (block == ObjectRegistry.AGED_THATCH.get()) {
            return (Block)ObjectRegistry.DRYING_THATCH.get();
        }
        return null;
    }

    default public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.thatch.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.thatch.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.thatch.info_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

