/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RailingBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<RailingBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BlockState.CODEC.fieldOf("base_state").forGetter(b -> b.baseState), (App)RailingBlock.propertiesCodec()).apply((Applicative)i, RailingBlock::new));
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape[] INNER_LEFT_SHAPES = new VoxelShape[4];
    protected static final VoxelShape[] INNER_RIGHT_SHAPES = new VoxelShape[4];
    protected static final VoxelShape[] FULL_SHAPES = new VoxelShape[4];
    protected static final VoxelShape[] OUTER_LEFT_SHAPES = new VoxelShape[4];
    protected static final VoxelShape[] OUTER_RIGHT_SHAPES = new VoxelShape[4];
    public static final EnumProperty<Size> SIZE = EnumProperty.create((String)"size", Size.class);
    private final Block base;
    protected final BlockState baseState;

    private static int rotFromSouth(int facingIndex) {
        if (facingIndex == 0) {
            return 2;
        }
        if (facingIndex == 1) {
            return 3;
        }
        if (facingIndex == 2) {
            return 0;
        }
        return 1;
    }

    private static VoxelShape buildRotated(double[][] boxes, int rot) {
        VoxelShape shape = Shapes.empty();
        for (double[] b : boxes) {
            double[] t = RailingBlock.rotateBox(b, rot);
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)t[0], (double)t[1], (double)t[2], (double)t[3], (double)t[4], (double)t[5]), (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    private static double[] rotateBox(double[] b, int rot) {
        double x1 = b[0];
        double y1 = b[1];
        double z1 = b[2];
        double x2 = b[3];
        double y2 = b[4];
        double z2 = b[5];
        if (rot == 0) {
            return new double[]{x1, y1, z1, x2, y2, z2};
        }
        if (rot == 1) {
            return new double[]{1.0 - z2, y1, x1, 1.0 - z1, y2, x2};
        }
        if (rot == 2) {
            return new double[]{1.0 - x2, y1, 1.0 - z2, 1.0 - x1, y2, 1.0 - z1};
        }
        return new double[]{z1, y1, 1.0 - x2, z2, y2, 1.0 - x1};
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int f = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        StairsShape s = (StairsShape)state.getValue(SHAPE);
        Size size = (Size)((Object)state.getValue(SIZE));
        if (size == Size.HALF) {
            if (s == StairsShape.INNER_LEFT || s == StairsShape.INNER_RIGHT) {
                return RailingBlock.rotateInnerHalfShape(f, s);
            }
            if (s == StairsShape.OUTER_LEFT || s == StairsShape.OUTER_RIGHT) {
                return RailingBlock.rotateOuterHalfShape(f, s);
            }
            return RailingBlock.rotateHalfShape(f);
        }
        if (size == Size.QUARTER) {
            if (s == StairsShape.INNER_LEFT || s == StairsShape.INNER_RIGHT) {
                return RailingBlock.rotateInnerQuarterShape(f, s);
            }
            if (s == StairsShape.OUTER_LEFT || s == StairsShape.OUTER_RIGHT) {
                return RailingBlock.rotateOuterQuarterShape(f, s);
            }
            return RailingBlock.rotateQuarterShape(f);
        }
        if (s == StairsShape.OUTER_LEFT) {
            return OUTER_LEFT_SHAPES[f];
        }
        if (s == StairsShape.OUTER_RIGHT) {
            return OUTER_RIGHT_SHAPES[f];
        }
        if (s == StairsShape.INNER_LEFT) {
            return INNER_LEFT_SHAPES[f];
        }
        if (s == StairsShape.INNER_RIGHT) {
            return INNER_RIGHT_SHAPES[f];
        }
        return FULL_SHAPES[f];
    }

    private static VoxelShape rotateHalfShape(int rot) {
        double[][] boxes = new double[][]{{0.75, 0.0, 0.0, 0.9375, 0.5, 0.1875}, {0.0625, 0.0, 0.0, 0.25, 0.5, 0.1875}, {0.40625, 0.0, 0.0, 0.59375, 0.5, 0.1875}, {0.0, 0.5, 0.0, 1.0, 0.75, 0.25}};
        return RailingBlock.buildRotated(boxes, rot + 2 & 3);
    }

    private static VoxelShape rotateQuarterShape(int rot) {
        double[][] boxes = new double[][]{{0.75, 0.0, 0.0, 0.9375, 0.25, 0.1875}, {0.0625, 0.0, 0.0, 0.25, 0.25, 0.1875}, {0.40625, 0.0, 0.0, 0.59375, 0.25, 0.1875}, {0.0, 0.25, 0.0, 1.0, 0.5, 0.25}};
        return RailingBlock.buildRotated(boxes, rot + 2 & 3);
    }

    private static VoxelShape rotateInnerHalfShape(int rot, StairsShape s) {
        double[][] boxes = new double[][]{{0.75, 0.0, 0.0, 0.9375, 0.5, 0.1875}, {0.0, 0.0, 0.75, 0.1875, 0.5, 0.9375}, {0.0625, 0.0, 0.0625, 0.25, 0.5, 0.25}, {0.40625, 0.0, 0.0, 0.59375, 0.5, 0.1875}, {0.0, 0.0, 0.40625, 0.1875, 0.5, 0.59375}, {0.0, 0.5, 0.0, 1.0, 0.75, 0.25}, {0.0, 0.5, 0.25, 0.25, 0.75, 1.0}};
        int baseRot = RailingBlock.rotFromSouth(rot);
        int finalRot = s == StairsShape.INNER_RIGHT ? baseRot + 1 & 3 : baseRot;
        return RailingBlock.buildRotated(boxes, finalRot);
    }

    private static VoxelShape rotateInnerQuarterShape(int rot, StairsShape s) {
        double[][] boxes = new double[][]{{0.75, 0.0, 0.0, 0.9375, 0.25, 0.1875}, {0.0, 0.0, 0.75, 0.1875, 0.25, 0.9375}, {0.0625, 0.0, 0.0625, 0.25, 0.25, 0.25}, {0.40625, 0.0, 0.0, 0.59375, 0.25, 0.1875}, {0.0, 0.0, 0.40625, 0.1875, 0.25, 0.59375}, {0.0, 0.25, 0.0, 1.0, 0.5, 0.25}, {0.0, 0.25, 0.25, 0.25, 0.5, 1.0}};
        int baseRot = RailingBlock.rotFromSouth(rot);
        int finalRot = s == StairsShape.INNER_RIGHT ? baseRot + 1 & 3 : baseRot;
        return RailingBlock.buildRotated(boxes, finalRot);
    }

    private static VoxelShape rotateOuterHalfShape(int rot, StairsShape s) {
        double[][] boxes = new double[][]{{0.0, 0.5, 0.0, 0.25, 0.75, 0.25}};
        int baseRot = RailingBlock.rotFromSouth(rot);
        int finalRot = s == StairsShape.OUTER_RIGHT ? baseRot + 1 & 3 : baseRot;
        return RailingBlock.buildRotated(boxes, finalRot);
    }

    private static VoxelShape rotateOuterQuarterShape(int rot, StairsShape s) {
        double[][] boxes = new double[][]{{0.0, 0.25, 0.0, 0.25, 0.5, 0.25}};
        int baseRot = RailingBlock.rotFromSouth(rot);
        int finalRot = s == StairsShape.OUTER_RIGHT ? baseRot + 1 & 3 : baseRot;
        return RailingBlock.buildRotated(boxes, finalRot);
    }

    @NotNull
    public MapCodec<? extends RailingBlock> codec() {
        return CODEC;
    }

    public RailingBlock(BlockState baseState, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(SIZE, (Comparable)((Object)Size.FULL)));
        this.base = baseState.getBlock();
        this.baseState = baseState;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() instanceof AxeItem) {
            if (!level.isClientSide) {
                VoxelShape shape = this.getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
                AABB box = shape.bounds();
                double cx = (double)pos.getX() + box.minX + (box.maxX - box.minX) / 2.0;
                double cy = (double)pos.getY() + box.minY + (box.maxY - box.minY) / 2.0;
                double cz = (double)pos.getZ() + box.minZ + (box.maxZ - box.minZ) / 2.0;
                ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), cx, cy, cz, 12, 0.1, 0.1, 0.1, 0.05);
                level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            Size next = RailingBlock.nextSize((Size)((Object)state.getValue(SIZE)));
            level.setBlock(pos, (BlockState)state.setValue(SIZE, (Comparable)((Object)next)), 11);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public float getExplosionResistance() {
        return this.base.getExplosionResistance();
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        FluidState fluid = ctx.getLevel().getFluidState(pos);
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        return (BlockState)state.setValue(SHAPE, (Comparable)RailingBlock.getStairsShape(state, (BlockGetter)ctx.getLevel(), pos));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction dir, BlockState adj, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return dir.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)RailingBlock.getStairsShape(state, (BlockGetter)level, pos)) : super.updateShape(state, dir, adj, level, pos, pos2);
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction f3;
        Direction f2;
        Direction f = (Direction)state.getValue((Property)FACING);
        BlockState fwd = level.getBlockState(pos.relative(f));
        if (RailingBlock.isCompatibleStair(fwd) && (f2 = (Direction)fwd.getValue((Property)FACING)).getAxis() != f.getAxis() && RailingBlock.canTakeShape(state, level, pos, f2.getOpposite())) {
            if (f2 == f.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState back = level.getBlockState(pos.relative(f.getOpposite()));
        if (RailingBlock.isCompatibleStair(back) && (f3 = (Direction)back.getValue((Property)FACING)).getAxis() != f.getAxis() && RailingBlock.canTakeShape(state, level, pos, f3)) {
            if (f3 == f.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction dir) {
        BlockState s = level.getBlockState(pos.relative(dir));
        return !RailingBlock.isCompatibleStair(s) || s.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    public static boolean isCompatibleStair(BlockState state) {
        return state.getBlock() instanceof RailingBlock;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        Direction f = (Direction)state.getValue((Property)FACING);
        StairsShape sh = (StairsShape)state.getValue(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (f.getAxis() != Direction.Axis.Z) break;
                return switch (sh) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (f.getAxis() != Direction.Axis.X) break;
                return switch (sh) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{FACING, SHAPE, WATERLOGGED, SIZE});
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static Size nextSize(Size s) {
        if (s == Size.FULL) {
            return Size.HALF;
        }
        if (s == Size.HALF) {
            return Size.QUARTER;
        }
        return Size.FULL;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.railing.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }

    static {
        double[][] full = new double[][]{{0.75, 0.0, 0.8125, 0.9375, 0.75, 1.0}, {0.0625, 0.0, 0.8125, 0.25, 0.75, 1.0}, {0.40625, 0.0, 0.8125, 0.59375, 0.75, 1.0}, {0.0, 0.75, 0.75, 1.0, 1.0, 1.0}};
        double[][] outer = new double[][]{{0.0, 0.75, 0.0, 0.25, 1.0, 0.25}};
        double[][] inner = new double[][]{{0.75, 0.0, 0.0, 0.9375, 0.75, 0.1875}, {0.0, 0.0, 0.75, 0.1875, 0.75, 0.9375}, {0.0625, 0.0, 0.0625, 0.25, 0.75, 0.25}, {0.40625, 0.0, 0.0, 0.59375, 0.75, 0.1875}, {0.0, 0.0, 0.40625, 0.1875, 0.75, 0.59375}, {0.0, 0.75, 0.0, 1.0, 1.0, 0.25}, {0.0, 0.75, 0.25, 0.25, 1.0, 1.0}};
        for (int f = 0; f < 4; ++f) {
            RailingBlock.FULL_SHAPES[f] = RailingBlock.buildRotated(full, f);
            int baseRot = RailingBlock.rotFromSouth(f);
            RailingBlock.INNER_LEFT_SHAPES[f] = RailingBlock.buildRotated(inner, baseRot);
            RailingBlock.INNER_RIGHT_SHAPES[f] = RailingBlock.buildRotated(inner, baseRot + 1 & 3);
            RailingBlock.OUTER_LEFT_SHAPES[f] = RailingBlock.buildRotated(outer, baseRot);
            RailingBlock.OUTER_RIGHT_SHAPES[f] = RailingBlock.buildRotated(outer, baseRot + 1 & 3);
        }
    }

    public static enum Size implements StringRepresentable
    {
        FULL,
        HALF,
        QUARTER;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

