/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.entity.SlidingDoorBlockEntity;
import net.satisfy.hearth_and_timber.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlidingStableDoorBlock
extends BaseEntityBlock {
    public static final MapCodec<SlidingStableDoorBlock> CODEC = SlidingStableDoorBlock.simpleCodec(SlidingStableDoorBlock::new);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<HingeSide> HINGE = EnumProperty.create((String)"hinge", HingeSide.class);
    public static final EnumProperty<Half> PART = EnumProperty.create((String)"part", Half.class);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    private static final VoxelShape NORTH_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
    private static final VoxelShape SOUTH_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.8125, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape WEST_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.1875, (double)1.0, (double)1.0);
    private static final VoxelShape EAST_SHAPE = Shapes.box((double)0.8125, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public SlidingStableDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HINGE, (Comparable)((Object)HingeSide.LEFT))).setValue(PART, (Comparable)((Object)Half.BOTTOM))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public MapCodec<SlidingStableDoorBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HINGE, PART, OPEN});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        HingeSide hinge;
        Direction direction = context.getHorizontalDirection().getOpposite();
        BlockPos origin = context.getClickedPos();
        Level level = context.getLevel();
        double hitX = context.getClickLocation().x - (double)origin.getX();
        double hitZ = context.getClickLocation().z - (double)origin.getZ();
        switch (direction) {
            case NORTH: {
                hinge = hitX > 0.5 ? HingeSide.RIGHT : HingeSide.LEFT;
                break;
            }
            case SOUTH: {
                hinge = hitX > 0.5 ? HingeSide.LEFT : HingeSide.RIGHT;
                break;
            }
            case WEST: {
                hinge = hitZ > 0.5 ? HingeSide.LEFT : HingeSide.RIGHT;
                break;
            }
            default: {
                HingeSide hingeSide = hinge = hitZ > 0.5 ? HingeSide.RIGHT : HingeSide.LEFT;
            }
        }
        if (!this.isReplaceable(level, origin)) {
            return null;
        }
        if (!this.isReplaceable(level, origin.above())) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(HINGE, (Comparable)((Object)hinge))).setValue(PART, (Comparable)((Object)Half.BOTTOM))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    private boolean isReplaceable(Level level, BlockPos position) {
        return level.getBlockState(position).canBeReplaced();
    }

    public void setPlacedBy(Level level, BlockPos position, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        HingeSide hinge = (HingeSide)((Object)state.getValue(HINGE));
        boolean open = (Boolean)state.getValue((Property)OPEN);
        level.setBlock(position.above(), (BlockState)((BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)Half.TOP))).setValue(HINGE, (Comparable)((Object)hinge))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos position, BlockState state, Player player) {
        if (!level.isClientSide) {
            BlockPos origin = this.resolveOrigin(position, state);
            if (!player.isCreative()) {
                SlidingStableDoorBlock.popResource((Level)level, (BlockPos)origin, (ItemStack)new ItemStack((ItemLike)this.asItem()));
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            HingeSide hinge = (HingeSide)((Object)state.getValue(HINGE));
            Direction lateral = this.lateralDirection(direction, hinge);
            this.destroyIfPresent(level, origin.above(2), state);
            this.destroyIfPresent(level, origin.above(), state);
            BlockPos right = origin.relative(lateral);
            this.destroyIfPresent(level, right.above(2), state);
            this.destroyIfPresent(level, right.above(), state);
            this.destroyIfPresent(level, right, state);
            this.destroyIfPresent(level, origin, state);
        }
        return state;
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return List.of();
    }

    public void onRemove(BlockState state, Level level, BlockPos position, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && state.getBlock() != newState.getBlock()) {
            BlockPos origin = this.resolveOrigin(position, state);
            this.destroyIfPresent(level, origin.above(), state);
            this.destroyIfPresent(level, origin, state);
        }
        super.onRemove(state, level, position, newState, isMoving);
    }

    private Direction lateralDirection(Direction facing, HingeSide hinge) {
        return hinge == HingeSide.RIGHT ? facing.getClockWise() : facing.getCounterClockWise();
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean changed;
        BlockPos origin = this.resolveOrigin(pos, state);
        BlockEntity be = level.getBlockEntity(origin);
        if (be instanceof SlidingDoorBlockEntity) {
            SlidingDoorBlockEntity door = (SlidingDoorBlockEntity)be;
            if (door.isReinforced() && stack.getItem() instanceof PickaxeItem) {
                if (!level.isClientSide) {
                    door.setReinforced(false);
                    SlidingStableDoorBlock.popResource((Level)level, (BlockPos)origin, (ItemStack)new ItemStack((ItemLike)Items.IRON_INGOT));
                    if (level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        double x = (double)origin.getX() + 0.5;
                        double y = (double)origin.getY() + 0.5;
                        double z = (double)origin.getZ() + 0.5;
                        server.playSound(null, origin, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                        server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.IRON_BLOCK.defaultBlockState()), x, y, z, 20, 0.35, 0.3, 0.35, 0.02);
                    }
                }
                return level.isClientSide ? ItemInteractionResult.SUCCESS : ItemInteractionResult.CONSUME;
            }
            if (stack.is(Items.IRON_INGOT)) {
                if (!level.isClientSide && !door.isReinforced()) {
                    door.setReinforced(true);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        double x = (double)origin.getX() + 0.5;
                        double y = (double)origin.getY() + 0.5;
                        double z = (double)origin.getZ() + 0.5;
                        server.playSound(null, origin, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                        server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.IRON_BLOCK.defaultBlockState()), x, y, z, 16, 0.35, 0.3, 0.35, 0.02);
                    }
                }
                return level.isClientSide ? ItemInteractionResult.SUCCESS : ItemInteractionResult.CONSUME;
            }
            if (door.isReinforced()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        if (changed = this.tryRecolorWithPlanks(level, pos, player, hand, stack)) {
            return level.isClientSide ? ItemInteractionResult.SUCCESS : ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean open;
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos origin = this.resolveOrigin(pos, state);
        BlockPos other = this.findOppositeOrigin(level, origin, state);
        boolean bl = open = (Boolean)level.getBlockState(origin).getValue((Property)OPEN) == false;
        if (other != null) {
            Direction f1 = (Direction)state.getValue((Property)FACING);
            HingeSide h1 = (HingeSide)((Object)state.getValue(HINGE));
            this.setOpenFlag(level, origin, f1, h1, open);
            BlockState s2 = level.getBlockState(other);
            if (s2.getBlock() == this) {
                Direction f2 = (Direction)s2.getValue((Property)FACING);
                HingeSide h2 = (HingeSide)((Object)s2.getValue(HINGE));
                this.setOpenFlag(level, other, f2, h2, open);
            }
            return InteractionResult.SUCCESS;
        }
        Direction f = (Direction)state.getValue((Property)FACING);
        HingeSide h = (HingeSide)((Object)state.getValue(HINGE));
        this.setOpenFlag(level, origin, f, h, open);
        return InteractionResult.SUCCESS;
    }

    private BlockPos findOppositeOrigin(Level level, BlockPos origin, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        for (int d = 1; d <= 3; ++d) {
            BlockPos p = origin.relative(direction, d);
            BlockState s = level.getBlockState(p);
            if (s.getBlock() == this && s.getValue((Property)FACING) == direction.getOpposite()) {
                return this.resolveOrigin(p, s);
            }
            BlockPos p2 = origin.relative(direction.getOpposite(), d);
            BlockState s2 = level.getBlockState(p2);
            if (s2.getBlock() != this || s2.getValue((Property)FACING) != direction.getOpposite()) continue;
            return this.resolveOrigin(p2, s2);
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Half part = (Half)((Object)state.getValue(PART));
        if (part == Half.TOP) {
            return level.getBlockState(pos.below()).getBlock() == this;
        }
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    private void setOpenFlag(Level level, BlockPos origin, Direction facing, HingeSide hinge, boolean open) {
        BlockEntity be;
        BlockState tl;
        BlockPos topPos = origin.above();
        BlockState bl = level.getBlockState(origin);
        if (bl.getBlock() == this) {
            level.setBlock(origin, (BlockState)bl.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
        if ((tl = level.getBlockState(topPos)).getBlock() == this) {
            level.setBlock(topPos, (BlockState)tl.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
        if ((be = level.getBlockEntity(origin)) instanceof SlidingDoorBlockEntity) {
            SlidingDoorBlockEntity d = (SlidingDoorBlockEntity)be;
            d.setOpen(open, true);
        }
    }

    private void destroyIfPresent(Level level, BlockPos position, BlockState referenceState) {
        BlockState at = level.getBlockState(position);
        if (at.getBlock() == this && at.getValue((Property)FACING) == referenceState.getValue((Property)FACING) && at.getValue(HINGE) == referenceState.getValue(HINGE)) {
            level.destroyBlock(position, false);
        }
    }

    private BlockPos resolveOrigin(BlockPos position, BlockState state) {
        Half part = (Half)((Object)state.getValue(PART));
        if (part == Half.BOTTOM) {
            return position;
        }
        return position.below();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos position, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        HingeSide hinge = (HingeSide)((Object)state.getValue(HINGE));
        boolean open = (Boolean)state.getValue((Property)OPEN);
        if (!open) {
            if (facing == Direction.NORTH) {
                return NORTH_SHAPE;
            }
            if (facing == Direction.SOUTH) {
                return SOUTH_SHAPE;
            }
            if (facing == Direction.WEST) {
                return WEST_SHAPE;
            }
            return EAST_SHAPE;
        }
        Direction lateral = this.lateralDirection(facing, hinge);
        double t = 0.1875;
        double w = 0.375;
        double d = 0.0625;
        if (facing == Direction.NORTH) {
            if (lateral == Direction.WEST) {
                return Shapes.box((double)0.0, (double)0.0, (double)d, (double)w, (double)1.0, (double)(d + t));
            }
            return Shapes.box((double)(1.0 - w), (double)0.0, (double)d, (double)1.0, (double)1.0, (double)(d + t));
        }
        if (facing == Direction.SOUTH) {
            if (lateral == Direction.WEST) {
                return Shapes.box((double)0.0, (double)0.0, (double)(1.0 - d - t), (double)w, (double)1.0, (double)(1.0 - d));
            }
            return Shapes.box((double)(1.0 - w), (double)0.0, (double)(1.0 - d - t), (double)1.0, (double)1.0, (double)(1.0 - d));
        }
        if (facing == Direction.WEST) {
            if (lateral == Direction.NORTH) {
                return Shapes.box((double)d, (double)0.0, (double)0.0, (double)(d + t), (double)1.0, (double)w);
            }
            return Shapes.box((double)d, (double)0.0, (double)(1.0 - w), (double)(d + t), (double)1.0, (double)1.0);
        }
        if (lateral == Direction.NORTH) {
            return Shapes.box((double)(1.0 - d - t), (double)0.0, (double)0.0, (double)(1.0 - d), (double)1.0, (double)w);
        }
        return Shapes.box((double)(1.0 - d - t), (double)0.0, (double)(1.0 - w), (double)(1.0 - d), (double)1.0, (double)1.0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos position, BlockState state) {
        return new SlidingDoorBlockEntity(position, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != EntityTypeRegistry.SLIDING_DOOR_BLOCK_ENTITY.get()) {
            return null;
        }
        if (level.isClientSide) {
            return null;
        }
        return (srv, pos, st, be) -> {
            if (be instanceof SlidingDoorBlockEntity) {
                SlidingDoorBlockEntity e = (SlidingDoorBlockEntity)be;
                SlidingDoorBlockEntity.serverTick(srv, pos, st, e);
            }
        };
    }

    private static String woodKeyFromPlanks(BlockState plankState) {
        if (plankState.is(Blocks.OAK_PLANKS)) {
            return "oak";
        }
        if (plankState.is(Blocks.SPRUCE_PLANKS)) {
            return "spruce";
        }
        if (plankState.is(Blocks.BIRCH_PLANKS)) {
            return "birch";
        }
        if (plankState.is(Blocks.JUNGLE_PLANKS)) {
            return "jungle";
        }
        if (plankState.is(Blocks.ACACIA_PLANKS)) {
            return "acacia";
        }
        if (plankState.is(Blocks.DARK_OAK_PLANKS)) {
            return "dark_oak";
        }
        if (plankState.is(Blocks.CHERRY_PLANKS)) {
            return "cherry";
        }
        if (plankState.is(Blocks.MANGROVE_PLANKS)) {
            return "mangrove";
        }
        if (plankState.is(Blocks.BAMBOO_PLANKS)) {
            return "bamboo";
        }
        if (plankState.is(Blocks.CRIMSON_PLANKS)) {
            return "crimson";
        }
        if (plankState.is(Blocks.WARPED_PLANKS)) {
            return "warped";
        }
        return null;
    }

    private static BlockState planksFromWoodKey(String key) {
        return switch (key) {
            case "oak" -> Blocks.OAK_PLANKS.defaultBlockState();
            case "birch" -> Blocks.BIRCH_PLANKS.defaultBlockState();
            case "jungle" -> Blocks.JUNGLE_PLANKS.defaultBlockState();
            case "acacia" -> Blocks.ACACIA_PLANKS.defaultBlockState();
            case "dark_oak" -> Blocks.DARK_OAK_PLANKS.defaultBlockState();
            case "cherry" -> Blocks.CHERRY_PLANKS.defaultBlockState();
            case "mangrove" -> Blocks.MANGROVE_PLANKS.defaultBlockState();
            case "bamboo" -> Blocks.BAMBOO_PLANKS.defaultBlockState();
            case "crimson" -> Blocks.CRIMSON_PLANKS.defaultBlockState();
            case "warped" -> Blocks.WARPED_PLANKS.defaultBlockState();
            default -> Blocks.SPRUCE_PLANKS.defaultBlockState();
        };
    }

    private boolean tryRecolorWithPlanks(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        BlockPos origin;
        BlockEntity be;
        BlockItem b;
        BlockItem blockItem;
        ItemStack held = stack;
        Item item = held.getItem();
        BlockItem blockItem2 = blockItem = item instanceof BlockItem ? (b = (BlockItem)item) : null;
        if (blockItem == null) {
            BlockItem b2;
            ItemStack other = hand == InteractionHand.MAIN_HAND ? player.getOffhandItem() : player.getMainHandItem();
            Item item2 = other.getItem();
            BlockItem blockItem3 = blockItem = item2 instanceof BlockItem ? (b2 = (BlockItem)item2) : null;
            if (blockItem == null) {
                return false;
            }
            held = other;
        }
        if (!((be = level.getBlockEntity(origin = this.resolveOrigin(pos, level.getBlockState(pos)))) instanceof SlidingDoorBlockEntity)) {
            return false;
        }
        SlidingDoorBlockEntity door = (SlidingDoorBlockEntity)be;
        if (door.isReinforced()) {
            return false;
        }
        BlockState plankState = blockItem.getBlock().defaultBlockState();
        String newKey = SlidingStableDoorBlock.woodKeyFromPlanks(plankState);
        if (newKey == null) {
            return false;
        }
        String oldKey = door.getWood();
        if (newKey.equals(oldKey)) {
            return true;
        }
        if (!level.isClientSide) {
            if (level instanceof ServerLevel) {
                BlockPos[] points;
                ServerLevel server = (ServerLevel)level;
                BlockState oldPlanks = SlidingStableDoorBlock.planksFromWoodKey(oldKey);
                for (BlockPos p : points = new BlockPos[]{origin, origin.above()}) {
                    double cx = (double)p.getX() + 0.5;
                    double cy = (double)p.getY() + 0.1;
                    double cz = (double)p.getZ() + 0.5;
                    server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, oldPlanks), cx, cy, cz, 18, 0.35, 0.25, 0.35, 0.03);
                    server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, plankState), cx, cy, cz, 18, 0.35, 0.25, 0.35, 0.03);
                }
                server.playSound(null, origin, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 0.95f + server.random.nextFloat() * 0.1f);
            }
            door.setWood(newKey);
            if (!player.getAbilities().instabuild) {
                held.shrink(1);
            }
        }
        return true;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.sliding_door.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.sliding_door.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }

    public static enum HingeSide implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private HingeSide(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Half implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private Half(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

