/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class SplitstonePathBlock
extends Block {
    public static final MapCodec<SplitstonePathBlock> CODEC = SplitstonePathBlock.simpleCodec(SplitstonePathBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private Supplier<Block> base = () -> (Block)ObjectRegistry.SPLITSTONE.get();

    public SplitstonePathBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setBase(Supplier<Block> supplier) {
        this.base = supplier;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    @NotNull
    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState self = this.defaultBlockState();
        if (!self.canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos())) {
            Block block;
            Block block2 = block = this.base != null ? this.base.get() : null;
            if (block == null) {
                block = (Block)ObjectRegistry.SPLITSTONE.get();
            }
            BlockState replacement = block.defaultBlockState();
            return Block.pushEntitiesUp((BlockState)self, (BlockState)replacement, (LevelAccessor)ctx.getLevel(), (BlockPos)ctx.getClickedPos());
        }
        return super.getStateForPlacement(ctx);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction dir, BlockState other, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        if (dir == Direction.UP && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, dir, other, level, pos, fromPos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Block block;
        Block block2 = block = this.base != null ? this.base.get() : null;
        if (block == null) {
            block = (Block)ObjectRegistry.SPLITSTONE.get();
        }
        if (block != null) {
            level.setBlockAndUpdate(pos, block.defaultBlockState());
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState above = level.getBlockState(pos.above());
        return !above.isSolid() || above.getBlock() instanceof FenceGateBlock;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

