/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.TimberFoundationBlock;
import org.jetbrains.annotations.NotNull;

public class TimberBaseSkirtBlock
extends TimberFoundationBlock {
    public static final EnumProperty<Half> HALF = EnumProperty.create((String)"half", Half.class);
    protected static final VoxelShape BASE_STRAIGHT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    protected static final VoxelShape BASE_INNER = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0));
    protected static final VoxelShape BASE_OUTER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0);
    protected static final VoxelShape[] STRAIGHT_BY_FACING = new VoxelShape[]{TimberBaseSkirtBlock.rotateY(BASE_STRAIGHT, Direction.NORTH), TimberBaseSkirtBlock.rotateY(BASE_STRAIGHT, Direction.EAST), TimberBaseSkirtBlock.rotateY(BASE_STRAIGHT, Direction.SOUTH), TimberBaseSkirtBlock.rotateY(BASE_STRAIGHT, Direction.WEST)};
    protected static final VoxelShape[] INNER_LEFT_BY_FACING = new VoxelShape[]{TimberBaseSkirtBlock.rotateY(BASE_INNER, Direction.NORTH), TimberBaseSkirtBlock.rotateY(BASE_INNER, Direction.EAST), TimberBaseSkirtBlock.rotateY(BASE_INNER, Direction.SOUTH), TimberBaseSkirtBlock.rotateY(BASE_INNER, Direction.WEST)};
    protected static final VoxelShape[] INNER_RIGHT_BY_FACING = new VoxelShape[]{TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_INNER), Direction.NORTH), TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_INNER), Direction.EAST), TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_INNER), Direction.SOUTH), TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_INNER), Direction.WEST)};
    protected static final VoxelShape[] OUTER_LEFT_BY_FACING = new VoxelShape[]{TimberBaseSkirtBlock.rotateY(BASE_OUTER, Direction.NORTH), TimberBaseSkirtBlock.rotateY(BASE_OUTER, Direction.EAST), TimberBaseSkirtBlock.rotateY(BASE_OUTER, Direction.SOUTH), TimberBaseSkirtBlock.rotateY(BASE_OUTER, Direction.WEST)};
    protected static final VoxelShape[] OUTER_RIGHT_BY_FACING = new VoxelShape[]{TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_OUTER), Direction.NORTH), TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_OUTER), Direction.EAST), TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_OUTER), Direction.SOUTH), TimberBaseSkirtBlock.rotateY(TimberBaseSkirtBlock.mirrorX(BASE_OUTER), Direction.WEST)};

    public TimberBaseSkirtBlock(BlockState baseState, BlockBehaviour.Properties properties) {
        super(baseState, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean top;
        BlockState s = super.getStateForPlacement(context);
        Direction face = context.getClickedFace();
        boolean bl = top = face == Direction.DOWN || face != Direction.UP && context.getClickLocation().y - (double)context.getClickedPos().getY() > 0.5;
        assert (s != null);
        return (BlockState)s.setValue(HALF, (Comparable)(top ? Half.TOP : Half.BOTTOM));
    }

    @Override
    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        int idx = switch (direction) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        VoxelShape shape = switch ((StairsShape)state.getValue((Property)SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> STRAIGHT_BY_FACING[idx];
            case StairsShape.INNER_LEFT -> INNER_LEFT_BY_FACING[idx];
            case StairsShape.INNER_RIGHT -> INNER_RIGHT_BY_FACING[idx];
            case StairsShape.OUTER_LEFT -> OUTER_LEFT_BY_FACING[idx];
            case StairsShape.OUTER_RIGHT -> OUTER_RIGHT_BY_FACING[idx];
        };
        return state.getValue(HALF) == Half.TOP ? TimberBaseSkirtBlock.moveShapeUp(shape) : shape;
    }

    private static VoxelShape rotateY(VoxelShape shape, Direction direction) {
        int r = switch (direction) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        VoxelShape s = shape;
        for (int i = 0; i < r; ++i) {
            s = TimberBaseSkirtBlock.rotateOnceY(s);
        }
        return s;
    }

    private static VoxelShape rotateOnceY(VoxelShape shape) {
        VoxelShape out = Shapes.empty();
        for (AABB a : shape.toAabbs()) {
            out = Shapes.or((VoxelShape)out, (VoxelShape)Block.box((double)((1.0 - a.maxZ) * 16.0), (double)(a.minY * 16.0), (double)(a.minX * 16.0), (double)((1.0 - a.minZ) * 16.0), (double)(a.maxY * 16.0), (double)(a.maxX * 16.0)));
        }
        return out;
    }

    private static VoxelShape mirrorX(VoxelShape shape) {
        VoxelShape out = Shapes.empty();
        for (AABB a : shape.toAabbs()) {
            out = Shapes.or((VoxelShape)out, (VoxelShape)Block.box((double)((1.0 - a.maxX) * 16.0), (double)(a.minY * 16.0), (double)(a.minZ * 16.0), (double)((1.0 - a.minX) * 16.0), (double)(a.maxY * 16.0), (double)(a.maxZ * 16.0)));
        }
        return out;
    }

    private static VoxelShape moveShapeUp(VoxelShape shape) {
        VoxelShape out = Shapes.empty();
        for (AABB a : shape.toAabbs()) {
            out = Shapes.or((VoxelShape)out, (VoxelShape)Block.box((double)(a.minX * 16.0), (double)(a.minY * 16.0 + 14.0), (double)(a.minZ * 16.0), (double)(a.maxX * 16.0), (double)(a.maxY * 16.0 + 14.0), (double)(a.maxZ * 16.0)));
        }
        return out;
    }
}

