/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.TimberFrameBlock;
import net.satisfy.hearth_and_timber.core.block.entity.TimberFrameBlockEntity;
import org.jetbrains.annotations.NotNull;

public class TimberFoundationBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<TimberFoundationBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("base_state").forGetter(b -> b.baseState), (App)TimberFoundationBlock.propertiesCodec()).apply((Applicative)instance, TimberFoundationBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty APPLIED = BooleanProperty.create((String)"applied");
    protected static final VoxelShape BASE_STRAIGHT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape BASE_INNER = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
    protected static final VoxelShape BASE_OUTER = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape[] STRAIGHT_BY_FACING = new VoxelShape[]{TimberFoundationBlock.rotateY(BASE_STRAIGHT, Direction.NORTH), TimberFoundationBlock.rotateY(BASE_STRAIGHT, Direction.EAST), TimberFoundationBlock.rotateY(BASE_STRAIGHT, Direction.SOUTH), TimberFoundationBlock.rotateY(BASE_STRAIGHT, Direction.WEST)};
    protected static final VoxelShape[] INNER_LEFT_BY_FACING = new VoxelShape[]{TimberFoundationBlock.rotateY(BASE_INNER, Direction.NORTH), TimberFoundationBlock.rotateY(BASE_INNER, Direction.EAST), TimberFoundationBlock.rotateY(BASE_INNER, Direction.SOUTH), TimberFoundationBlock.rotateY(BASE_INNER, Direction.WEST)};
    protected static final VoxelShape[] INNER_RIGHT_BY_FACING = new VoxelShape[]{TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_INNER), Direction.NORTH), TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_INNER), Direction.EAST), TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_INNER), Direction.SOUTH), TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_INNER), Direction.WEST)};
    protected static final VoxelShape[] OUTER_LEFT_BY_FACING = new VoxelShape[]{TimberFoundationBlock.rotateY(BASE_OUTER, Direction.NORTH), TimberFoundationBlock.rotateY(BASE_OUTER, Direction.EAST), TimberFoundationBlock.rotateY(BASE_OUTER, Direction.SOUTH), TimberFoundationBlock.rotateY(BASE_OUTER, Direction.WEST)};
    protected static final VoxelShape[] OUTER_RIGHT_BY_FACING = new VoxelShape[]{TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_OUTER), Direction.NORTH), TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_OUTER), Direction.EAST), TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_OUTER), Direction.SOUTH), TimberFoundationBlock.rotateY(TimberFoundationBlock.mirrorX(BASE_OUTER), Direction.WEST)};
    private final Block base;
    protected final BlockState baseState;

    public TimberFoundationBlock(BlockState baseState, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false)));
        this.base = baseState.getBlock();
        this.baseState = baseState;
    }

    @NotNull
    public MapCodec<? extends TimberFoundationBlock> codec() {
        return CODEC;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        int idx = switch (direction) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        return switch ((StairsShape)state.getValue(SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> STRAIGHT_BY_FACING[idx];
            case StairsShape.INNER_LEFT -> INNER_LEFT_BY_FACING[idx];
            case StairsShape.INNER_RIGHT -> INNER_RIGHT_BY_FACING[idx];
            case StairsShape.OUTER_LEFT -> OUTER_LEFT_BY_FACING[idx];
            case StairsShape.OUTER_RIGHT -> OUTER_RIGHT_BY_FACING[idx];
        };
    }

    private static VoxelShape rotateY(VoxelShape shape, Direction direction) {
        int r = switch (direction) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        VoxelShape s = shape;
        for (int i = 0; i < r; ++i) {
            s = TimberFoundationBlock.rotateOnceY(s);
        }
        return s;
    }

    private static VoxelShape rotateOnceY(VoxelShape shape) {
        VoxelShape out = Shapes.empty();
        for (AABB a : shape.toAabbs()) {
            out = Shapes.or((VoxelShape)out, (VoxelShape)Block.box((double)((1.0 - a.maxZ) * 16.0), (double)(a.minY * 16.0), (double)(a.minX * 16.0), (double)((1.0 - a.minZ) * 16.0), (double)(a.maxY * 16.0), (double)(a.maxX * 16.0)));
        }
        return out;
    }

    private static VoxelShape mirrorX(VoxelShape shape) {
        VoxelShape out = Shapes.empty();
        for (AABB a : shape.toAabbs()) {
            out = Shapes.or((VoxelShape)out, (VoxelShape)Block.box((double)((1.0 - a.maxX) * 16.0), (double)(a.minY * 16.0), (double)(a.minZ * 16.0), (double)((1.0 - a.minX) * 16.0), (double)(a.maxY * 16.0), (double)(a.maxZ * 16.0)));
        }
        return out;
    }

    public float getExplosionResistance() {
        return this.base.getExplosionResistance();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluid = context.getLevel().getFluidState(pos);
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false));
        return (BlockState)state.setValue(SHAPE, (Comparable)TimberFoundationBlock.getShapeFor(state, (BlockGetter)context.getLevel(), pos));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return dir.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)TimberFoundationBlock.getShapeFor(state, (BlockGetter)level, pos)) : super.updateShape(state, dir, neighbor, level, pos, neighborPos);
    }

    private static StairsShape getShapeFor(BlockState state, BlockGetter level, BlockPos pos) {
        Direction direction3;
        Direction direction2;
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState front = level.getBlockState(pos.relative(facing));
        if (TimberFoundationBlock.isFoundation(front) && (direction2 = (Direction)front.getValue((Property)FACING)).getAxis() != facing.getAxis() && TimberFoundationBlock.canTakeShape(state, level, pos, direction2.getOpposite())) {
            return direction2 == facing.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState back = level.getBlockState(pos.relative(facing.getOpposite()));
        if (TimberFoundationBlock.isFoundation(back) && (direction3 = (Direction)back.getValue((Property)FACING)).getAxis() != facing.getAxis() && TimberFoundationBlock.canTakeShape(state, level, pos, direction3)) {
            return direction3 == facing.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction dir) {
        BlockState other = level.getBlockState(pos.relative(dir));
        return !TimberFoundationBlock.isFoundation(other) || other.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    public static boolean isFoundation(BlockState state) {
        return state.getBlock() instanceof TimberFoundationBlock;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (shape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (shape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> state.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return super.mirror(state, mirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE, WATERLOGGED, APPLIED});
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TimberFrameBlockEntity(pos, state);
    }

    private static boolean canAccept(BlockGetter level, BlockPos pos, BlockState state) {
        if (state == null || state.isAir()) {
            return false;
        }
        if (state.getBlock() instanceof EntityBlock) {
            return false;
        }
        if (state.getBlock() instanceof TimberFrameBlock) {
            return false;
        }
        if (state.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        return Block.isShapeFullBlock((VoxelShape)state.getShape(level, pos));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() instanceof PickaxeItem) {
            TimberFrameBlockEntity fbe;
            BlockState mimic;
            if (!((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof TimberFrameBlockEntity && (mimic = (fbe = (TimberFrameBlockEntity)be).getMimicState()) != null && !mimic.isAir()) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)mimic.getBlock()));
                fbe.setMimicState(Blocks.AIR.defaultBlockState());
                level.setBlock(pos, (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false)), 3);
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.levelEvent(2001, pos, Block.getId((BlockState)mimic));
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item fbe = stack.getItem();
        if (!(fbe instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem blockItem = (BlockItem)fbe;
        BlockState mimic = blockItem.getBlock().defaultBlockState();
        if (!TimberFoundationBlock.canAccept((BlockGetter)level, pos, mimic)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TimberFrameBlockEntity) {
            TimberFrameBlockEntity fbe2 = (TimberFrameBlockEntity)blockEntity;
            fbe2.setMimicState(mimic);
            level.setBlock(pos, (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.levelEvent(2001, pos, Block.getId((BlockState)mimic));
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        TimberFrameBlockEntity fbe;
        BlockState mimic;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof TimberFrameBlockEntity && (mimic = (fbe = (TimberFrameBlockEntity)be).getMimicState()) != null && !mimic.isAir() && !player.isCreative()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)mimic.getBlock()));
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame_full.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

