/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.entity.TimberFrameBlockEntity;
import org.jetbrains.annotations.NotNull;

public class TimberFrameBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<TimberFrameBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("base_state").forGetter(block -> block.baseState), (App)TimberFrameBlock.propertiesCodec()).apply((Applicative)instance, TimberFrameBlock::new));
    public static final BooleanProperty WATERLOGGED = BooleanProperty.create((String)"waterlogged");
    public static final BooleanProperty APPLIED = BooleanProperty.create((String)"applied");
    private final Block base;
    protected final BlockState baseState;

    public TimberFrameBlock(BlockState baseState, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false)));
        this.base = baseState.getBlock();
        this.baseState = baseState;
    }

    @NotNull
    public MapCodec<? extends TimberFrameBlock> codec() {
        return CODEC;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public float getExplosionResistance() {
        return this.base.getExplosionResistance();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluid = context.getLevel().getFluidState(pos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER))).setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighbor, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, APPLIED});
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TimberFrameBlockEntity(pos, state);
    }

    private static boolean canAccept(BlockGetter level, BlockPos pos, BlockState candidate) {
        if (candidate == null || candidate.isAir()) {
            return false;
        }
        if (candidate.getBlock() instanceof EntityBlock) {
            return false;
        }
        if (candidate.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        return Block.isShapeFullBlock((VoxelShape)candidate.getShape(level, pos));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (itemStack.getItem() instanceof PickaxeItem) {
            TimberFrameBlockEntity timberFrameBlockEntity;
            BlockState mimicState;
            if (!((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof TimberFrameBlockEntity && (mimicState = (timberFrameBlockEntity = (TimberFrameBlockEntity)blockEntity).getMimicState()) != null && !mimicState.isAir()) {
                Block.popResource((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)mimicState.getBlock()));
                timberFrameBlockEntity.setMimicState(null);
                BlockState newState = (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false));
                level.setBlock(blockPos, newState, 3);
                level.sendBlockUpdated(blockPos, state, newState, 3);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.levelEvent(2001, blockPos, Block.getId((BlockState)mimicState));
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item timberFrameBlockEntity = itemStack.getItem();
        if (!(timberFrameBlockEntity instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem blockItem = (BlockItem)timberFrameBlockEntity;
        BlockState mimicState = blockItem.getBlock().defaultBlockState();
        if (!TimberFrameBlock.canAccept((BlockGetter)level, blockPos, mimicState)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof TimberFrameBlockEntity) {
            TimberFrameBlockEntity timberFrameBlockEntity2 = (TimberFrameBlockEntity)blockEntity;
            timberFrameBlockEntity2.setMimicState(mimicState);
            BlockState newState = (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(true));
            level.setBlock(blockPos, newState, 3);
            level.sendBlockUpdated(blockPos, state, newState, 3);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.levelEvent(2001, blockPos, Block.getId((BlockState)mimicState));
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        TimberFrameBlockEntity timberFrameBlockEntity;
        BlockState mimic;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TimberFrameBlockEntity && (mimic = (timberFrameBlockEntity = (TimberFrameBlockEntity)blockEntity).getMimicState()) != null && !mimic.isAir() && !player.isCreative()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)mimic.getBlock()));
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame_trim.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

