/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.hearth_and_timber.core.block.entity.TimberFrameBlockEntity;
import org.jetbrains.annotations.NotNull;

public class TimberFrameStairsBlock
extends StairBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty APPLIED = BooleanProperty.create((String)"applied");

    public TimberFrameStairsBlock(BlockState baseShapeState, BlockBehaviour.Properties properties) {
        super(baseShapeState, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{APPLIED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placedState = super.getStateForPlacement(context);
        return placedState == null ? null : (BlockState)placedState.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, blockPos, neighborPos);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new TimberFrameBlockEntity(blockPos, state);
    }

    private static boolean canAccept(BlockGetter blockGetter, BlockPos blockPos, BlockState candidateState) {
        if (candidateState == null || candidateState.isAir()) {
            return false;
        }
        if (candidateState.getBlock() instanceof EntityBlock) {
            return false;
        }
        if (candidateState.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        return Block.isShapeFullBlock((VoxelShape)candidateState.getShape(blockGetter, blockPos));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (itemStack.getItem() instanceof PickaxeItem) {
            TimberFrameBlockEntity timberFrameBlockEntity;
            BlockState mimicState;
            if (!((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof TimberFrameBlockEntity && (mimicState = (timberFrameBlockEntity = (TimberFrameBlockEntity)blockEntity).getMimicState()) != null && !mimicState.isAir()) {
                Block.popResource((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)mimicState.getBlock()));
                timberFrameBlockEntity.setMimicState(null);
                level.setBlock(blockPos, (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(false)), 3);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.levelEvent(2001, blockPos, Block.getId((BlockState)mimicState));
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if (((Boolean)state.getValue((Property)APPLIED)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Item timberFrameBlockEntity = itemStack.getItem();
        if (!(timberFrameBlockEntity instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem blockItem = (BlockItem)timberFrameBlockEntity;
        BlockState mimicState = blockItem.getBlock().defaultBlockState();
        if (!TimberFrameStairsBlock.canAccept((BlockGetter)level, blockPos, mimicState)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof TimberFrameBlockEntity) {
            TimberFrameBlockEntity timberFrameBlockEntity2 = (TimberFrameBlockEntity)blockEntity;
            timberFrameBlockEntity2.setMimicState(mimicState);
            level.setBlock(blockPos, (BlockState)state.setValue((Property)APPLIED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.levelEvent(2001, blockPos, Block.getId((BlockState)mimicState));
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState state, Player player) {
        TimberFrameBlockEntity timberFrameBlockEntity;
        BlockState mimicState;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof TimberFrameBlockEntity && (mimicState = (timberFrameBlockEntity = (TimberFrameBlockEntity)blockEntity).getMimicState()) != null && !mimicState.isAir() && !player.isCreative()) {
            Block.popResource((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)mimicState.getBlock()));
        }
        super.playerWillDestroy(level, blockPos, state, player);
        return state;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            components.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        components.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        components.add((Component)Component.empty());
        components.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame_trim.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        components.add((Component)Component.empty());
        components.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.timber_frame.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

