/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBlock
extends IronBarsBlock {
    public static final IntegerProperty PART = IntegerProperty.create((String)"part", (int)0, (int)3);

    public WindowBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide()) {
            this.updateWindows((LevelAccessor)world, pos);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (direction.getAxis().isVertical()) {
            this.updateWindows(world, pos);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
        if (!world.isClientSide()) {
            this.updateWindows((LevelAccessor)world, pos);
        }
    }

    private void updateWindows(LevelAccessor world, BlockPos pos) {
        BlockPos lowest = this.getLowestWindow(world, pos);
        BlockPos highest = this.getHighestWindow(world, pos);
        int height = 0;
        BlockPos p = lowest;
        while (p.compareTo((Vec3i)highest) <= 0) {
            ++height;
            p = p.above();
        }
        if (height == 1) {
            BlockState cs = world.getBlockState(lowest);
            if (cs.getBlock() == this) {
                world.setBlock(lowest, (BlockState)cs.setValue((Property)PART, (Comparable)Integer.valueOf(0)), 3);
            }
            return;
        }
        BlockState c0 = world.getBlockState(lowest);
        if (c0.getBlock() == this) {
            world.setBlock(lowest, (BlockState)c0.setValue((Property)PART, (Comparable)Integer.valueOf(1)), 3);
        }
        if (height == 2) {
            BlockState c1 = world.getBlockState(highest);
            if (c1.getBlock() == this) {
                world.setBlock(highest, (BlockState)c1.setValue((Property)PART, (Comparable)Integer.valueOf(3)), 3);
            }
            return;
        }
        BlockPos p2 = lowest.above();
        while (p2.compareTo((Vec3i)highest) < 0) {
            BlockState cs = world.getBlockState(p2);
            if (cs.getBlock() == this) {
                world.setBlock(p2, (BlockState)cs.setValue((Property)PART, (Comparable)Integer.valueOf(2)), 3);
            }
            p2 = p2.above();
        }
        BlockState ct = world.getBlockState(highest);
        if (ct.getBlock() == this) {
            world.setBlock(highest, (BlockState)ct.setValue((Property)PART, (Comparable)Integer.valueOf(3)), 3);
        }
    }

    private BlockPos getLowestWindow(LevelAccessor world, BlockPos pos) {
        while (world.getBlockState(pos.below()).getBlock() == this) {
            pos = pos.below();
        }
        return pos;
    }

    private BlockPos getHighestWindow(LevelAccessor world, BlockPos pos) {
        while (world.getBlockState(pos.above()).getBlock() == this) {
            pos = pos.above();
        }
        return pos;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }
}

