/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WindowCasingBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.create((String)"right");
    public static final BooleanProperty BOTTOM_TOGGLE = BooleanProperty.create((String)"bottom_toggle");
    private static final VoxelShape NORTH_PLANE = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_PLANE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape EAST_PLANE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_PLANE = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_LEFT = Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_RIGHT = Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_TOP = Block.box((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_BOTTOM = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape SOUTH_LEFT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_RIGHT = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
    private static final VoxelShape EAST_LEFT = Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_RIGHT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
    private static final VoxelShape EAST_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0);
    private static final VoxelShape WEST_LEFT = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape WEST_RIGHT = Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TOP = Block.box((double)14.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_BOTTOM = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public WindowCasingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM_TOGGLE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER))).setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM_TOGGLE, (Comparable)Boolean.valueOf(false));
        return this.updateConnections(state, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.updateConnections(state, level, pos);
    }

    private boolean isConnected(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockState other = level.getBlockState(pos);
        return other.getBlock() instanceof WindowCasingBlock && other.getValue((Property)FACING) == facing;
    }

    private boolean hasSameBelow(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockState below = level.getBlockState(pos.below());
        return below.getBlock() instanceof WindowCasingBlock && below.getValue((Property)FACING) == facing;
    }

    private BlockState updateConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean right;
        boolean left;
        boolean top;
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean north = this.isConnected(level, pos.north(), facing);
        boolean east = this.isConnected(level, pos.east(), facing);
        boolean south = this.isConnected(level, pos.south(), facing);
        boolean west = this.isConnected(level, pos.west(), facing);
        boolean up = this.isConnected(level, pos.above(), facing);
        boolean bottom = (Boolean)state.getValue((Property)BOTTOM);
        if (!((Boolean)state.getValue((Property)BOTTOM_TOGGLE)).booleanValue()) {
            boolean bl = bottom = !this.hasSameBelow(level, pos, facing);
        }
        if (facing == Direction.NORTH) {
            top = !up;
            left = !east;
            right = !west;
        } else if (facing == Direction.SOUTH) {
            top = !up;
            left = !west;
            right = !east;
        } else if (facing == Direction.EAST) {
            top = !up;
            left = !south;
            right = !north;
        } else {
            top = !up;
            left = !north;
            right = !south;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(left))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(right))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(stack.getItem() instanceof AxeItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (hit.getDirection() != state.getValue((Property)FACING)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        double hitY = hit.getLocation().y - (double)pos.getY();
        if (hitY >= 0.5) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean newBottom = (Boolean)state.getValue((Property)BOTTOM) == false;
        BlockState newState = (BlockState)((BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(newBottom))).setValue((Property)BOTTOM_TOGGLE, (Comparable)Boolean.valueOf(true));
        if (!level.isClientSide) {
            level.setBlock(pos, newState, 2);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.levelEvent(2001, pos, Block.getId((BlockState)state));
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        VoxelShape shape = Shapes.empty();
        if (facing == Direction.NORTH) {
            if (((Boolean)state.getValue((Property)LEFT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_LEFT);
            }
            if (((Boolean)state.getValue((Property)RIGHT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_RIGHT);
            }
            if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_TOP);
            }
            if (((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_BOTTOM);
            }
            if (shape.isEmpty()) {
                shape = NORTH_PLANE;
            }
        } else if (facing == Direction.SOUTH) {
            if (((Boolean)state.getValue((Property)LEFT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_LEFT);
            }
            if (((Boolean)state.getValue((Property)RIGHT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_RIGHT);
            }
            if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_TOP);
            }
            if (((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_BOTTOM);
            }
            if (shape.isEmpty()) {
                shape = SOUTH_PLANE;
            }
        } else if (facing == Direction.EAST) {
            if (((Boolean)state.getValue((Property)LEFT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_LEFT);
            }
            if (((Boolean)state.getValue((Property)RIGHT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_RIGHT);
            }
            if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_TOP);
            }
            if (((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_BOTTOM);
            }
            if (shape.isEmpty()) {
                shape = EAST_PLANE;
            }
        } else if (facing == Direction.WEST) {
            if (((Boolean)state.getValue((Property)LEFT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_LEFT);
            }
            if (((Boolean)state.getValue((Property)RIGHT)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_RIGHT);
            }
            if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_TOP);
            }
            if (((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_BOTTOM);
            }
            if (shape.isEmpty()) {
                shape = WEST_PLANE;
            }
        }
        return shape;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, TOP, BOTTOM, LEFT, RIGHT, BOTTOM_TOGGLE});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.window_casing.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.window_casing.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

