/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block;

import java.util.List;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class WoodenBoardBlock
extends Block {
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"layers", (int)0, (int)3);
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public WoodenBoardBlock() {
        super(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(0))).setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int height = ((Integer)state.getValue((Property)LAYERS) + 1) * 4;
        if (height >= 16) {
            return Shapes.block();
        }
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return Block.box((double)0.0, (double)(16 - height), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS, TOP, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Direction face = context.getClickedFace();
        double localY = context.getClickLocation().y - (double)blockPos.getY();
        boolean isTop = face == Direction.DOWN || face != Direction.UP && localY > 0.5;
        Direction facing = context.getHorizontalDirection();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(0))).setValue((Property)TOP, (Comparable)Boolean.valueOf(isTop))).setValue((Property)FACING, (Comparable)facing);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean validHit;
        Direction face = hit.getDirection();
        boolean isTop = (Boolean)state.getValue((Property)TOP);
        double localY = hit.getLocation().y - (double)pos.getY();
        if (!isTop) {
            validHit = face == Direction.UP || face.getAxis().isHorizontal() && localY > 0.5;
        } else {
            boolean bl = validHit = face == Direction.DOWN || face.getAxis().isHorizontal() && localY < 0.5;
        }
        if (!validHit) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() != this.asItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            int current = (Integer)state.getValue((Property)LAYERS);
            if (current < 3) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(current + 1)), 3);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.CONSUME;
            }
            BlockPos targetPos = isTop ? pos.below() : pos.above();
            BlockState targetState = level.getBlockState(targetPos);
            if (targetState.canBeReplaced() || targetState.isAir()) {
                level.setBlock(targetPos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(0))).setValue((Property)TOP, (Comparable)Boolean.valueOf(isTop))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                level.playSound(null, targetPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        int current;
        ItemStack heldItem;
        boolean validHit;
        Direction face = hit.getDirection();
        boolean isTop = (Boolean)state.getValue((Property)TOP);
        double localY = hit.getLocation().y - (double)pos.getY();
        if (!isTop) {
            validHit = face == Direction.UP || face.getAxis().isHorizontal() && localY > 0.5;
        } else {
            boolean bl = validHit = face == Direction.DOWN || face.getAxis().isHorizontal() && localY < 0.5;
        }
        if (!validHit) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide && (heldItem = player.getMainHandItem()).getItem() instanceof AxeItem && (current = ((Integer)state.getValue((Property)LAYERS)).intValue()) > 0) {
            WoodenBoardBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem()));
            level.setBlock(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(current - 1)), 3);
            level.playSound(null, pos, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                heldItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        int beige = 16113331;
        int gold = 16766720;
        if (!Screen.hasShiftDown()) {
            MutableComponent key = Component.literal((String)"[SHIFT]").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)gold)));
            tooltipList.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.tooltip_information.hold", (Object[])new Object[]{key}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
            return;
        }
        tooltipList.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.board.info_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
        tooltipList.add((Component)Component.empty());
        tooltipList.add((Component)Component.translatable((String)"tooltip.hearth_and_timber.board.info_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)beige))));
    }
}

