/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.hearth_and_timber.core.block.SlidingBarnDoorBlock;
import net.satisfy.hearth_and_timber.core.block.SlidingHayloftDoorBlock;
import net.satisfy.hearth_and_timber.core.block.SlidingStableDoorBlock;
import net.satisfy.hearth_and_timber.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class SlidingDoorBlockEntity
extends BlockEntity {
    private boolean open;
    private long animStart;
    private boolean animForward;
    private boolean playedOpenSound;
    private boolean playedCloseSound;
    private boolean allowInteractionSounds = false;
    private String wood = "spruce";
    private boolean reinforced;

    public SlidingDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.SLIDING_DOOR_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean isReinforced() {
        return this.reinforced;
    }

    public void setReinforced(boolean value) {
        if (this.reinforced != value) {
            this.reinforced = value;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void setOpen(boolean value, boolean playSound) {
        long now = System.currentTimeMillis();
        float current = this.getSlide();
        this.open = value;
        this.animForward = value;
        this.animStart = this.animForward ? now - (long)(current * 12000.0f) : now - (long)((1.0f - current) * 12000.0f);
        if (playSound) {
            this.allowInteractionSounds = true;
            if (this.animForward) {
                this.playedOpenSound = false;
                this.playedCloseSound = true;
            } else {
                this.playedCloseSound = false;
                this.playedOpenSound = true;
            }
        } else {
            this.allowInteractionSounds = false;
            this.playedOpenSound = true;
            this.playedCloseSound = true;
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static void serverTick(Level level, BlockPos position, BlockState state, SlidingDoorBlockEntity be) {
        float volume;
        float pitch;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        float slide = be.getSlide();
        if (be.allowInteractionSounds && be.animForward && !be.playedOpenSound) {
            pitch = 1.2f + server.random.nextFloat() * 0.6f;
            volume = 0.5f + server.random.nextFloat() * 0.3f;
            server.playSound(null, position, SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, volume, pitch);
            be.playedOpenSound = true;
        }
        if (be.allowInteractionSounds && !be.animForward && !be.playedCloseSound) {
            pitch = 0.9f + server.random.nextFloat() * 0.5f;
            volume = 0.5f + server.random.nextFloat() * 0.3f;
            server.playSound(null, position, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, volume, pitch);
            be.playedCloseSound = true;
        }
        if (slide > 0.0f && slide < 1.0f && (server.getGameTime() & 3L) == 0L) {
            float distance = slide * 1.625f;
            Direction facing = SlidingDoorBlockEntity.getFacing(state);
            boolean right = SlidingDoorBlockEntity.isRightHinge(state);
            Direction lateral = right ? facing.getClockWise() : facing.getCounterClockWise();
            double offsetX = 0.0;
            double offsetZ = 0.0;
            switch (lateral) {
                case NORTH: {
                    offsetZ -= (double)distance;
                    break;
                }
                case SOUTH: {
                    offsetZ += (double)distance;
                    break;
                }
                case WEST: {
                    offsetX -= (double)distance;
                    break;
                }
                case EAST: {
                    offsetX += (double)distance;
                }
            }
            double forwardOffset = 0.0625 * (double)distance;
            switch (facing) {
                case NORTH: {
                    offsetZ -= forwardOffset;
                    break;
                }
                case SOUTH: {
                    offsetZ += forwardOffset;
                    break;
                }
                case WEST: {
                    offsetX -= forwardOffset;
                    break;
                }
                case EAST: {
                    offsetX += forwardOffset;
                }
            }
            double particleX = (double)position.getX() + 0.5 + offsetX;
            double particleY = (double)position.getY() + 0.02;
            double particleZ = (double)position.getZ() + 0.2 + offsetZ;
            BlockState below = server.getBlockState(position.below());
            server.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, below), particleX, particleY, particleZ, 4, 0.02, 0.0, 0.02, 0.0);
        }
        if (!be.animForward && slide <= 0.0f) {
            be.playedOpenSound = false;
        }
        if (be.animForward && slide >= 1.0f) {
            be.playedCloseSound = false;
        }
    }

    private static Direction getFacing(BlockState state) {
        Block b = state.getBlock();
        if (b instanceof SlidingBarnDoorBlock) {
            return (Direction)state.getValue((Property)SlidingBarnDoorBlock.FACING);
        }
        if (b instanceof SlidingHayloftDoorBlock) {
            return (Direction)state.getValue((Property)SlidingHayloftDoorBlock.FACING);
        }
        if (b instanceof SlidingStableDoorBlock) {
            return (Direction)state.getValue((Property)SlidingStableDoorBlock.FACING);
        }
        return Direction.NORTH;
    }

    private static boolean isRightHinge(BlockState state) {
        Block b = state.getBlock();
        if (b instanceof SlidingBarnDoorBlock) {
            SlidingBarnDoorBlock.HingeSide h = (SlidingBarnDoorBlock.HingeSide)((Object)state.getValue(SlidingBarnDoorBlock.HINGE));
            return h == SlidingBarnDoorBlock.HingeSide.RIGHT;
        }
        if (b instanceof SlidingHayloftDoorBlock) {
            SlidingHayloftDoorBlock.HingeSide h = (SlidingHayloftDoorBlock.HingeSide)((Object)state.getValue(SlidingHayloftDoorBlock.HINGE));
            return h == SlidingHayloftDoorBlock.HingeSide.RIGHT;
        }
        if (b instanceof SlidingStableDoorBlock) {
            SlidingStableDoorBlock.HingeSide h = (SlidingStableDoorBlock.HingeSide)((Object)state.getValue(SlidingStableDoorBlock.HINGE));
            return h == SlidingStableDoorBlock.HingeSide.RIGHT;
        }
        return false;
    }

    public float getSlide() {
        long now = System.currentTimeMillis();
        float t = (float)(now - this.animStart) / 1000.0f;
        if (t < 0.0f) {
            t = 0.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        return this.animForward ? t : 1.0f - t;
    }

    public String getWood() {
        return this.wood;
    }

    public void setWood(String value) {
        if (value != null && !value.isEmpty() && !value.equals(this.wood)) {
            this.wood = value;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.open = tag.getBoolean("open");
        this.animStart = tag.getLong("animStart");
        this.animForward = tag.getBoolean("animForward");
        this.playedOpenSound = tag.getBoolean("playedOpenSound");
        this.playedCloseSound = tag.getBoolean("playedCloseSound");
        if (tag.contains("wood")) {
            this.wood = tag.getString("wood");
        }
        this.reinforced = tag.getBoolean("reinforced");
        this.allowInteractionSounds = false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("open", this.open);
        tag.putLong("animStart", this.animStart);
        tag.putBoolean("animForward", this.animForward);
        tag.putBoolean("playedOpenSound", this.playedOpenSound);
        tag.putBoolean("playedCloseSound", this.playedCloseSound);
        tag.putString("wood", this.wood);
        tag.putBoolean("reinforced", this.reinforced);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

