/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.hearth_and_timber.HearthAndTimber;
import net.satisfy.hearth_and_timber.core.block.entity.SlidingDoorBlockEntity;
import net.satisfy.hearth_and_timber.core.block.entity.TimberFrameBlockEntity;
import net.satisfy.hearth_and_timber.core.registry.ObjectRegistry;

public class EntityTypeRegistry {
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"hearth_and_timber", (ResourceKey)Registries.BLOCK_ENTITY_TYPE).getRegistrar();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"hearth_and_timber", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<SlidingDoorBlockEntity>> SLIDING_DOOR_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("sliding_door", () -> BlockEntityType.Builder.of(SlidingDoorBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SLIDING_HAYLOFT_DOOR.get(), (Block)ObjectRegistry.SLIDING_BARN_DOOR.get(), (Block)ObjectRegistry.SLIDING_STABLE_DOOR.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<TimberFrameBlockEntity>> TIMBER_FRAME_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("timber_frame", () -> BlockEntityType.Builder.of(TimberFrameBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TIMBER_FOUNDATION.get(), (Block)ObjectRegistry.TIMBER_BASE_TRIM.get(), (Block)ObjectRegistry.TIMBER_BASE_SKIRT.get(), (Block)ObjectRegistry.TIMBER_FRAME.get(), (Block)ObjectRegistry.TIMBER_GRID_FRAME.get(), (Block)ObjectRegistry.TIMBER_CROSS_FRAME.get(), (Block)ObjectRegistry.TIMBER_DIAGONAL_FRAME.get(), (Block)ObjectRegistry.TIMBER_FRAME_STAIRS.get()}).build(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(HearthAndTimber.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
    }
}

