/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.neoforge.client;

import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.satisfy.hearth_and_timber.client.HearthAndTimberClient;
import net.satisfy.hearth_and_timber.neoforge.client.renderer.block.FoundationTexturedModel;

@EventBusSubscriber(modid="hearth_and_timber", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class HearthAndTimberClientNeoForge {
    @SubscribeEvent
    public static void beforeClientSetup(RegisterEvent event) {
        HearthAndTimberClient.preInitClient();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        HearthAndTimberClient.onInitializeClient();
    }

    @SubscribeEvent
    public static void wrapTimberFoundation(ModelEvent.ModifyBakingResult event) {
        Map models = event.getModels();
        for (Map.Entry entry : models.entrySet()) {
            BakedModel original;
            boolean isFramePlaceholder;
            ResourceLocation id = ((ModelResourceLocation)entry.getKey()).id();
            if (id == null || !"hearth_and_timber".equals(id.getNamespace())) continue;
            String path = id.getPath();
            boolean isFoundationPart = path.startsWith("block/timber_foundation") || path.startsWith("timber_foundation") || path.startsWith("block/timber_base_skirt") || path.startsWith("timber_base_skirt") || path.startsWith("block/timber_base_trim") || path.startsWith("timber_base_trim");
            boolean bl = isFramePlaceholder = path.startsWith("block/timber_frame") || path.startsWith("timber_frame") || path.startsWith("block/timber_grid_frame") || path.startsWith("timber_grid_frame") || path.startsWith("block/timber_diagonal_frame") || path.startsWith("timber_diagonal_frame") || path.startsWith("block/timber_cross_frame") || path.startsWith("timber_cross_frame");
            if (!isFoundationPart && !isFramePlaceholder || (original = (BakedModel)entry.getValue()) == null) continue;
            models.put((ModelResourceLocation)entry.getKey(), new FoundationTexturedModel(original, isFramePlaceholder));
        }
    }
}

