/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.neoforge.client.renderer.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.satisfy.hearth_and_timber.core.block.TimberFrameBlock;
import net.satisfy.hearth_and_timber.core.block.TimberFrameStairsBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoundationTexturedModel
implements BakedModel {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    private static final ThreadLocal<TextureAtlasSprite> TL_PARTICLE = new ThreadLocal();
    private final BakedModel original;
    private final boolean onlyPlaceholder;

    public FoundationTexturedModel(BakedModel original, boolean onlyPlaceholder) {
        this.original = original;
        this.onlyPlaceholder = onlyPlaceholder;
    }

    private static boolean isMissing(TextureAtlasSprite s) {
        if (s == null) {
            return true;
        }
        s.contents();
        return "missingno".equals(s.contents().name().getPath());
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    }

    private static TextureAtlasSprite targetSprite(@Nullable BlockState mimic, TextureAtlasSprite fallback) {
        if (mimic == null || mimic.isAir()) {
            return fallback;
        }
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(mimic);
        TextureAtlasSprite s = model.getParticleIcon();
        return FoundationTexturedModel.isMissing(s) ? fallback : s;
    }

    private static BakedQuad remapQuad(BakedQuad quad, TextureAtlasSprite dst) {
        TextureAtlasSprite src = quad.getSprite();
        if (src == dst) {
            return quad;
        }
        int[] verts = (int[])quad.getVertices().clone();
        int stride = IQuadTransformer.STRIDE;
        int uvBase = IQuadTransformer.UV0;
        float wScale = (float)dst.contents().width() / (float)src.contents().width();
        float hScale = (float)dst.contents().height() / (float)src.contents().height();
        for (int i = 0; i < 4; ++i) {
            int off = i * stride + uvBase;
            float uOrig = Float.intBitsToFloat(verts[off]);
            float vOrig = Float.intBitsToFloat(verts[off + 1]);
            float uRemap = (uOrig - src.getU0()) * wScale + dst.getU0();
            float vRemap = (vOrig - src.getV0()) * hScale + dst.getV0();
            verts[off] = Float.floatToRawIntBits(uRemap);
            verts[off + 1] = Float.floatToRawIntBits(vRemap);
        }
        return new BakedQuad(verts, quad.getTintIndex(), quad.getDirection(), dst, quad.isShade(), quad.hasAmbientOcclusion());
    }

    private static List<BakedQuad> remapAll(List<BakedQuad> in, TextureAtlasSprite dst, boolean onlyPlaceholder) {
        if (in.isEmpty()) {
            return in;
        }
        ArrayList<BakedQuad> out = new ArrayList<BakedQuad>(in.size());
        for (BakedQuad quad : in) {
            quad.getSprite();
            quad.getSprite().contents();
            boolean isPlaceholder = quad.getSprite().contents().name().getPath().contains("placeholder");
            if (!onlyPlaceholder || isPlaceholder) {
                out.add(FoundationTexturedModel.remapQuad(quad, dst));
                continue;
            }
            out.add(FoundationTexturedModel.remapQuad(quad, dst));
            out.add(quad);
        }
        return out;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.original.getQuads(state, side, rand);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType layer) {
        List base = this.original.getQuads(state, side, rand, data, layer);
        if (base.isEmpty()) {
            return base;
        }
        if (state != null) {
            if (state.getBlock() instanceof TimberFrameBlock && !((Boolean)state.getValue((Property)TimberFrameBlock.APPLIED)).booleanValue()) {
                return base;
            }
            if (state.getBlock() instanceof TimberFrameStairsBlock && !((Boolean)state.getValue((Property)TimberFrameStairsBlock.APPLIED)).booleanValue()) {
                return base;
            }
        }
        if (!data.has(MIMIC)) {
            return base;
        }
        BlockState mimic = (BlockState)data.get(MIMIC);
        if (mimic == null || mimic.isAir()) {
            return base;
        }
        TextureAtlasSprite dst = FoundationTexturedModel.targetSprite(mimic, this.original.getParticleIcon());
        if (FoundationTexturedModel.isMissing(dst)) {
            return base;
        }
        return FoundationTexturedModel.remapAll(base, dst, this.onlyPlaceholder);
    }

    public boolean useAmbientOcclusion() {
        return this.original.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.original.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.original.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.original.isCustomRenderer();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        TextureAtlasSprite t = TL_PARTICLE.get();
        if (t != null) {
            return t;
        }
        return this.original.getParticleIcon();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return this.original.getOverrides();
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.original.getTransforms();
    }
}

