/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.hearth_and_timber.neoforge.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.satisfy.hearth_and_timber.core.block.entity.TimberFrameBlockEntity;
import net.satisfy.hearth_and_timber.neoforge.client.renderer.block.FoundationTexturedModel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TimberFrameBlockEntity.class})
abstract class FoundationBlockEntityMixin {
    FoundationBlockEntityMixin() {
    }

    public ModelData getModelData() {
        BlockState mimic = ((TimberFrameBlockEntity)((Object)this)).getMimicState();
        if (mimic != null) {
            return ModelData.builder().with(FoundationTexturedModel.MIMIC, (Object)mimic).build();
        }
        return ModelData.EMPTY;
    }

    @Inject(method={"setMimicState(Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="TAIL")})
    private void hearthAndTimber$refreshModelData(BlockState state, CallbackInfo ci) {
        TimberFrameBlockEntity be = (TimberFrameBlockEntity)((Object)this);
        Level level = be.getLevel();
        if (level == null || !level.isClientSide) {
            return;
        }
        be.requestModelDataUpdate();
        BlockPos pos = be.getBlockPos();
        BlockState bs = be.getBlockState();
        level.sendBlockUpdated(pos, bs, bs, 10);
    }

    @Inject(method={"loadAdditional(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, at={@At(value="TAIL")})
    private void hearthAndTimber$refreshAfterLoad(CompoundTag tag, HolderLookup.Provider provider, CallbackInfo ci) {
        TimberFrameBlockEntity be = (TimberFrameBlockEntity)((Object)this);
        Level level = be.getLevel();
        if (level == null || !level.isClientSide) {
            return;
        }
        be.requestModelDataUpdate();
        BlockPos pos = be.getBlockPos();
        BlockState bs = be.getBlockState();
        level.sendBlockUpdated(pos, bs, bs, 10);
    }
}

