/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IEmitter
extends IRelatedUnit,
IPostInit {
    public static final Predicate<String> COMMON_ACTIVE_TAG_NAME = name -> Stream.of("active", "lit", "fuel", "enabled", "burn", "cook", "work", "process", "prog", "operat", "combust", "run", "rotat", "tick", "ison", "time").anyMatch(e -> name.toLowerCase(Locale.ROOT).contains((CharSequence)e));
    public static final String COMMENT_ACTIVE_STATE_TAG = "Defines the name of the NBT tag that stores info about tile entity active state.\nEmitter is considered active if the return value is greater than 0 or true.\nSet to an empty string if you don't need this function.";
    public static final String COMMENT_IDENTITY_TAG = "This parameter is required only for those blocks that use NBT tags to fully identify themselves.\nThe format is <tagKey>=<value>\nIf the value is a string, it must be enclosed in double quotes. Example: id=\"ic2:generator\"\nLeave this blank if you don't need it.";
    public static final String COMMENT_TYPE = "Defines the type of this emitter.\nValid types (case insensitive):\n  BLOCK - a simple Block without a Tile Entity that will be updated each time it receives a random tick.\n  TILE - a Block with a Tile Entity that will be updated onces per second.\n  ENTITY - a mobile Entity that will be updated onces per second.\n  FUEL - a Tile Entity with a HARDCODED hook that will be updated each time it consumes fuel.";
    public static final String COMMENT_RELATED_BLOCKS = "Defines a list of blocks which should be considered as part of this multiblock.";
    public static final String TAG_HARDCODED = "#hardcoded";

    public String getActiveTag();

    public KeyValuePair getIdentityTag();

    public Type getType();

    public Set<BlockState> getRelatedBlocks();

    default public boolean isActive(LevelReader level, BlockPos pos) {
        return switch (this.getType().ordinal()) {
            case 0 -> true;
            case 1, 3 -> {
                INBTSource<BlockEntity> source = INBTSource.of(level.getBlockEntity(pos));
                yield this.isActive(source);
            }
            default -> false;
        };
    }

    default public boolean isActive(INBTSource<?> nbtSource) {
        String tag = this.getActiveTag();
        if (tag == null || tag.isEmpty()) {
            return true;
        }
        if (nbtSource.source().isEmpty()) {
            return false;
        }
        CompoundTag compound = nbtSource.serialize();
        TagHelper.KeyPathPair pair = TagHelper.KeyPathPair.parse(tag);
        return TagHelper.getNestedCompound(compound, pair.path()).map(cmp -> cmp.getInt(pair.key())).filter(val -> val > 0).isPresent();
    }

    default public boolean isIdentified(INBTSource<?> nbtSource) {
        TagHelper.KeyPathPair pair;
        KeyValuePair id = this.getIdentityTag();
        if (id == null || id.key().isEmpty()) {
            return true;
        }
        if (nbtSource.source().isEmpty()) {
            return false;
        }
        CompoundTag compound = nbtSource.serialize();
        Tag tag = TagHelper.getTag(compound, pair = TagHelper.KeyPathPair.parse(id.key())).orElse(null);
        if (tag == null) {
            return false;
        }
        if (id.value().isEmpty()) {
            return true;
        }
        return id.value().equals(tag.toString());
    }

    public static enum Type {
        BLOCK,
        TILE,
        ENTITY,
        FUEL;


        public boolean isBlock() {
            return this == BLOCK;
        }

        public boolean isTile() {
            return this == TILE;
        }

        public boolean isEntity() {
            return this == ENTITY;
        }

        public boolean isFuel() {
            return this == FUEL;
        }

        public static Optional<Type> getByName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return Optional.of(type);
            }
            return Optional.empty();
        }

        public static Type getFrom(UnitConfig config, String category, Type defaultValue, String comment) {
            String name = UnitConfig.getStr(config, category, "type", defaultValue.name(), comment);
            Optional<Type> type = Type.getByName(name);
            if (type.isPresent()) {
                return type.get();
            }
            ForgeEndertech.getInstance().getLogger().error((String)("Invalid emitter type = '" + name + "'" + String.valueOf(config) != null ? " in " + config.getConfigFile().toString() : ""));
            return defaultValue;
        }
    }
}

