/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientItemExtensions
implements IClientItemExtensions {
    protected final BlockEntityWithoutLevelRenderer renderer;

    public static ClientItemExtensions of(ItemRendererProvider provider) {
        return new ClientItemExtensions(provider);
    }

    protected ClientItemExtensions(ItemRendererProvider provider) {
        Minecraft mc = Minecraft.getInstance();
        this.renderer = provider.create(mc.getBlockEntityRenderDispatcher(), mc.getEntityModels());
    }

    @Nullable
    public Font getFont(ItemStack stack, IClientItemExtensions.FontContext context) {
        return Minecraft.getInstance().font;
    }

    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        return this.renderer;
    }

    @FunctionalInterface
    public static interface ItemRendererProvider {
        public BlockEntityWithoutLevelRenderer create(BlockEntityRenderDispatcher var1, EntityModelSet var2);
    }
}

