/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.UnitId;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public abstract class ForgeNetMsg<MSG extends ForgeNetMsg<MSG>>
implements CustomPacketPayload {
    private static boolean synchronizationEnabled = false;
    private static final Map<Class<?>, FieldHandler<?>> fieldHandlers = new HashMap();
    private static final Map<Class<?>, Field[]> fieldCache = new HashMap();
    private static final Map<Class<?>, CustomPacketPayload.Type<? extends CustomPacketPayload>> msgTypes = new HashMap();

    public static void enableSynchronization() {
        synchronizationEnabled = true;
    }

    public void encode(MSG msg, FriendlyByteBuf buf) {
        ((ForgeNetMsg)msg).encodeTo(buf);
    }

    public MSG decode(FriendlyByteBuf buf) {
        MSG msg = this.create();
        ((ForgeNetMsg)msg).decodeFrom(buf);
        return msg;
    }

    public abstract MSG create();

    public abstract void handle(Level var1, Player var2);

    protected void consume(MSG msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> msg.handle(ctx.player().level(), ctx.player()));
    }

    public CustomPacketPayload.Type<MSG> type() {
        return msgTypes.computeIfAbsent(this.getClass(), key -> new CustomPacketPayload.Type(ForgeEndertech.getInstance().getNamespace().location(UnitId.getClassRegName(key))));
    }

    public void register(PayloadRegistrar registrar) {
        if (synchronizationEnabled) {
            registrar.playBidirectional(this.type(), StreamCodec.ofMember(this::encode, this::decode), this::consume);
        }
    }

    public void sendToPlayer(ServerPlayer player) {
        if (synchronizationEnabled) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToServer() {
        if (synchronizationEnabled) {
            PacketDistributor.sendToServer((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToAll() {
        if (synchronizationEnabled) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToAllInDimension(ServerLevel level) {
        if (synchronizationEnabled) {
            PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToAllAround(ServerLevel level, BlockPos pos, int radius) {
        if (synchronizationEnabled) {
            Vec3 center = pos.getCenter();
            PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)center.x, (double)center.y, (double)center.z, (double)radius, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToAllObservingChunk(ServerLevel level, BlockPos pos) {
        if (synchronizationEnabled) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected final void decodeFrom(FriendlyByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.readField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + String.valueOf(this), e);
        }
    }

    protected final void encodeTo(FriendlyByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.writeField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + String.valueOf(this), e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        Field[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = clazz.getFields();
            Arrays.sort(fields, Comparator.comparing(Field::getName));
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private void writeField(Field field, FriendlyByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            ((INetSerializable)value).writeTo(buf);
        } else if (type.isEnum()) {
            int ordinal = ((Enum)value).ordinal();
            buf.writeInt(ordinal);
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            handler.writer.write(value, buf);
        }
    }

    private void readField(Field field, FriendlyByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            value = ((INetSerializable)value).readFrom(buf);
        } else if (type.isEnum()) {
            int ordinal = buf.readInt();
            value = type.getEnumConstants()[ordinal];
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            value = handler.reader.read(buf);
        }
        field.set(this, value);
    }

    private static FieldHandler<?> getFieldHandler(Class<?> clazz) {
        FieldHandler<?> handler = fieldHandlers.get(clazz);
        if (handler == null) {
            throw new RuntimeException("No R/W handler for  " + String.valueOf(clazz));
        }
        return handler;
    }

    public static <T> void addFieldHandler(Class<T> type, IReader<T> reader, IWriter<T> writer) {
        fieldHandlers.put(type, new FieldHandler<T>(reader, writer));
    }

    private boolean acceptField(Field field) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        if (INetSerializable.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        return fieldHandlers.containsKey(type);
    }

    static {
        ForgeNetMsg.addFieldHandler(Byte.TYPE, FriendlyByteBuf::readByte, (value, buf) -> buf.writeByte(value.byteValue()));
        ForgeNetMsg.addFieldHandler(Short.TYPE, FriendlyByteBuf::readShort, (value, buf) -> buf.writeShort((int)value.shortValue()));
        ForgeNetMsg.addFieldHandler(Integer.TYPE, FriendlyByteBuf::readInt, (value, buf) -> buf.writeInt(value.intValue()));
        ForgeNetMsg.addFieldHandler(Long.TYPE, FriendlyByteBuf::readLong, (value, buf) -> buf.writeLong(value.longValue()));
        ForgeNetMsg.addFieldHandler(Float.TYPE, FriendlyByteBuf::readFloat, (value, buf) -> buf.writeFloat(value.floatValue()));
        ForgeNetMsg.addFieldHandler(Double.TYPE, FriendlyByteBuf::readDouble, (value, buf) -> buf.writeDouble(value.doubleValue()));
        ForgeNetMsg.addFieldHandler(Boolean.TYPE, FriendlyByteBuf::readBoolean, (value, buf) -> buf.writeBoolean(value.booleanValue()));
        ForgeNetMsg.addFieldHandler(Character.TYPE, FriendlyByteBuf::readChar, (value, buf) -> buf.writeChar((int)value.charValue()));
        ForgeNetMsg.addFieldHandler(String.class, FriendlyByteBuf::readUtf, (string, buf) -> buf.writeUtf(string));
        ForgeNetMsg.addFieldHandler(CompoundTag.class, buf -> buf.readNbt(), (compound, buf) -> buf.writeNbt((Tag)compound));
        ForgeNetMsg.addFieldHandler(BlockPos.class, buf -> buf.readBlockPos(), (pos, buf) -> buf.writeBlockPos(pos));
        ForgeNetMsg.addFieldHandler(Vect3d.class, Vect3d::readFromByteBuf, Vect3d::writeToByteBuf);
        ForgeNetMsg.addFieldHandler(BlockState.class, buf -> Block.stateById((int)buf.readInt()), (state, buf) -> buf.writeInt(Block.getId((BlockState)state)));
        ForgeNetMsg.addFieldHandler(ColorARGB.class, buf -> ColorARGB.from(buf.readInt()), (color, buf) -> buf.writeInt(color.getARGB()));
        ForgeNetMsg.addFieldHandler(Enum.class, null, (value, buf) -> buf.writeInt(value.ordinal()));
    }

    private record FieldHandler<T>(IReader<T> reader, IWriter<T> writer) {
    }

    static interface IWriter<T> {
        public void write(T var1, FriendlyByteBuf var2);
    }

    static interface IReader<T> {
        public T read(FriendlyByteBuf var1);
    }
}

