/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.world.GameWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileSharedDataMsg
extends ForgeNetMsg<TileSharedDataMsg> {
    public CompoundTag compound;
    public BlockPos pos;

    public TileSharedDataMsg() {
    }

    public TileSharedDataMsg(CompoundTag compound, BlockPos pos) {
        this.compound = compound;
        this.pos = pos;
    }

    @Override
    public TileSharedDataMsg create() {
        return new TileSharedDataMsg();
    }

    @Override
    public void handle(Level level, Player player) {
        if (!GameWorld.isBlockLoaded((LevelReader)level, this.pos)) {
            return;
        }
        BlockEntity tileEntity = level.getBlockEntity(this.pos);
        if (tileEntity instanceof ForgeTile) {
            ForgeTile tile = (ForgeTile)tileEntity;
            tile.readSharedData(this.compound, (HolderLookup.Provider)level.registryAccess());
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                tile.setChanged();
                this.sendToAllObservingChunk(serverLevel, this.pos);
            }
        }
    }
}

