/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractLanguageProvider
implements DataProvider {
    protected final String languageCode;
    protected final String modId;
    protected final PackOutput.PathProvider pathProvider;

    public AbstractLanguageProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String languageCode, DataProviderContext context) {
        this(languageCode, context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String modId, PackOutput packOutput) {
        this("en_us", modId, packOutput);
    }

    public AbstractLanguageProvider(String languageCode, String modId, PackOutput packOutput) {
        this.languageCode = languageCode;
        this.modId = modId;
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang");
    }

    public abstract void addTranslations(TranslationBuilder var1);

    public CompletableFuture<?> run(CachedOutput writer) {
        JsonObject jsonObject = new JsonObject();
        this.addTranslations((key, value) -> {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(value, "value is null");
            if (jsonObject.has(key)) {
                throw new IllegalStateException("Duplicate translation key found: " + key);
            }
            jsonObject.addProperty(key, value);
        });
        return DataProvider.saveStable((CachedOutput)writer, (JsonElement)jsonObject, (Path)this.pathProvider.json(ResourceLocationHelper.fromNamespaceAndPath(this.modId, this.languageCode)));
    }

    public String getName() {
        return "Language (%s)".formatted(this.languageCode);
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface TranslationBuilder {
        public void add(String var1, String var2);

        default public void add(String translationKey, String additionalKey, String value) {
            Objects.requireNonNull(additionalKey, "additional key is null");
            this.add(translationKey + (String)(additionalKey.isEmpty() ? "" : "." + additionalKey), value);
        }

        default public void add(ResourceLocation resourceLocation, String value) {
            this.add(resourceLocation, "", value);
        }

        default public void add(ResourceLocation resourceLocation, String additionalKey, String value) {
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.add(resourceLocation.toLanguageKey(), additionalKey, value);
        }

        default public void add(String registry, Holder<?> holder, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(holder, "holder is null");
            this.add(registry, (ResourceKey)holder.unwrapKey().orElseThrow(), value);
        }

        default public void add(String registry, ResourceKey<?> resourceKey, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceKey, "resource key is null");
            this.add(registry, resourceKey.location(), value);
        }

        default public void add(String registry, ResourceLocation resourceLocation, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.add(Util.makeDescriptionId((String)registry, (ResourceLocation)resourceLocation), value);
        }

        default public void add(TagKey<?> tagKey, String value) {
            this.add("tag." + tagKey.location().toLanguageKey(tagKey.registry().location().getPath()), value);
        }

        default public void addBlock(Holder<Block> block, String value) {
            this.add((Block)block.value(), value);
        }

        default public void add(Block block, String value) {
            this.add(block, "", value);
        }

        default public void add(Block block, String additionalKey, String value) {
            Objects.requireNonNull(block, "block is null");
            this.add(block.getDescriptionId(), additionalKey, value);
        }

        default public void addItem(Holder<Item> item, String value) {
            this.add((Item)item.value(), value);
        }

        default public void add(Item item, String value) {
            this.add(item, "", value);
        }

        default public void add(Item item, String additionalKey, String value) {
            Objects.requireNonNull(item, "item is null");
            this.add(item.getDescriptionId(), additionalKey, value);
        }

        default public void addSpawnEgg(Item item, String value) {
            if (!(item instanceof SpawnEggItem)) {
                throw new IllegalArgumentException("Unsupported item: " + String.valueOf(item));
            }
            this.add(item, value + " Spawn Egg");
        }

        default public void addEnchantment(ResourceKey<Enchantment> enchantment, String value) {
            this.addEnchantment(enchantment, "", value);
        }

        default public void addEnchantment(ResourceKey<Enchantment> enchantment, String additionalKey, String value) {
            Objects.requireNonNull(enchantment, "enchantment is null");
            String translationKey = Util.makeDescriptionId((String)enchantment.registry().getPath(), (ResourceLocation)enchantment.location());
            this.add(translationKey, additionalKey, value);
        }

        default public void addMobEffect(Holder<MobEffect> mobEffect, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add((MobEffect)mobEffect.value(), value);
        }

        default public void add(MobEffect mobEffect, String value) {
            this.add(mobEffect, "", value);
        }

        default public void add(MobEffect mobEffect, String additionalKey, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add(mobEffect.getDescriptionId(), additionalKey, value);
        }

        default public void addEntityType(Holder<EntityType<?>> entityType, String value) {
            this.add((EntityType)entityType.value(), value);
        }

        default public void add(EntityType<?> entityType, String value) {
            this.add(entityType, "", value);
        }

        default public void add(EntityType<?> entityType, String additionalKey, String value) {
            Objects.requireNonNull(entityType, "entity type is null");
            this.add(entityType.getDescriptionId(), additionalKey, value);
        }

        default public void addAttribute(Holder<Attribute> attribute, String value) {
            this.add((Attribute)attribute.value(), value);
        }

        default public void add(Attribute attribute, String value) {
            this.add(attribute, "", value);
        }

        default public void add(Attribute attribute, String additionalKey, String value) {
            Objects.requireNonNull(attribute, "attribute is null");
            this.add(attribute.getDescriptionId(), additionalKey, value);
        }

        default public void add(StatType<?> statType, String value) {
            this.add(statType, "", value);
        }

        default public void add(StatType<?> statType, String additionalKey, String value) {
            Objects.requireNonNull(statType, "stat type is null");
            Objects.requireNonNull(statType.getDisplayName(), "component is null");
            ComponentContents componentContents = statType.getDisplayName().getContents();
            if (!(componentContents instanceof TranslatableContents)) {
                throw new IllegalArgumentException("Unsupported component: " + String.valueOf(statType.getDisplayName()));
            }
            TranslatableContents contents = (TranslatableContents)componentContents;
            this.add(contents.getKey(), additionalKey, value);
        }

        default public void add(GameRules.Key<?> gameRule, String value) {
            this.add(gameRule, "", value);
        }

        default public void addGameRuleDescription(GameRules.Key<?> gameRule, String value) {
            this.add(gameRule, "description", value);
        }

        default public void add(GameRules.Key<?> gameRule, String additionalKey, String value) {
            Objects.requireNonNull(gameRule, "game rule is null");
            this.add(gameRule.getDescriptionId(), additionalKey, value);
        }

        default public void addPotion(Holder<Potion> potion, String value) {
            Objects.requireNonNull(potion, "potion is null");
            String potionName = Potion.getName(Optional.of(potion), (String)"");
            this.add("item.minecraft.tipped_arrow.effect." + potionName, "Arrow of " + value);
            this.add("item.minecraft.potion.effect." + potionName, "Potion of " + value);
            this.add("item.minecraft.splash_potion.effect." + potionName, "Splash Potion of " + value);
            this.add("item.minecraft.lingering_potion.effect." + potionName, "Lingering Potion of " + value);
        }

        default public void addSoundEvent(Holder<SoundEvent> soundEvent, String value) {
            this.add((SoundEvent)soundEvent.value(), value);
        }

        default public void add(SoundEvent soundEvent, String value) {
            Objects.requireNonNull(soundEvent, "sound event is null");
            this.add("subtitles." + soundEvent.getLocation().getPath(), value);
        }

        default public void add(KeyMapping keyMapping, String value) {
            Objects.requireNonNull(keyMapping, "key mapping is null");
            this.add(keyMapping.getName(), value);
        }

        default public void addKeyCategory(String modId, String value) {
            this.add("key.categories." + modId, value);
        }

        default public void addCreativeModeTab(String modId, String value) {
            this.addCreativeModeTab(modId, "main", value);
        }

        default public void addCreativeModeTab(String modId, String tabId, String value) {
            Objects.requireNonNull(modId, "mod id is null");
            Objects.requireNonNull(tabId, "tab id is null");
            this.addCreativeModeTab(ResourceLocationHelper.fromNamespaceAndPath(modId, tabId), value);
        }

        default public void addCreativeModeTab(ResourceLocation resourceLocation, String value) {
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.addCreativeModeTab((ResourceKey<CreativeModeTab>)ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)resourceLocation), value);
        }

        default public void addCreativeModeTab(ResourceKey<CreativeModeTab> resourceKey, String value) {
            Objects.requireNonNull(resourceKey, "resource key is null");
            this.add((CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(resourceKey), value);
        }

        default public void add(CreativeModeTab tab, String value) {
            Objects.requireNonNull(tab, "tab is null");
            this.add(tab.getDisplayName(), value);
        }

        default public void add(Component component, String value) {
            Objects.requireNonNull(component, "component is null");
            ComponentContents componentContents = component.getContents();
            if (!(componentContents instanceof TranslatableContents)) {
                throw new IllegalArgumentException("Unsupported component: " + String.valueOf(component));
            }
            TranslatableContents contents = (TranslatableContents)componentContents;
            this.add(contents.getKey(), value);
        }

        default public void addGenericDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.location().getPath(), value);
        }

        default public void addPlayerDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.location().getPath() + ".player", value);
        }

        default public void addItemDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.location().getPath() + ".item", value);
        }
    }
}

