/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import fuzs.puzzleslib.api.core.v1.ServiceProviderHelper;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface CommonAbstractions {
    public static final CommonAbstractions INSTANCE = ServiceProviderHelper.load(CommonAbstractions.class);

    public MinecraftServer getMinecraftServer();

    public boolean hasChannel(ServerPlayer var1, CustomPacketPayload.Type<?> var2);

    public void openMenu(ServerPlayer var1, MenuProvider var2, BiConsumer<ServerPlayer, RegistryFriendlyByteBuf> var3);

    public Entity getPartEntityParent(Entity var1);

    public boolean isBossMob(EntityType<?> var1);

    public float getEnchantPowerBonus(BlockState var1, Level var2, BlockPos var3);

    public boolean canEquip(ItemStack var1, EquipmentSlot var2, LivingEntity var3);

    default public int getMobLootingLevel(Entity target, @Nullable Entity attacker, @Nullable DamageSource damageSource) {
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            Holder<Enchantment> enchantment = LookupHelper.lookupEnchantment(target, (ResourceKey<Enchantment>)Enchantments.LOOTING);
            return EnchantmentHelper.getEnchantmentLevel(enchantment, (LivingEntity)livingEntity);
        }
        return 0;
    }

    public boolean getMobGriefingRule(Level var1, @Nullable Entity var2);

    public void onPlayerDestroyItem(Player var1, ItemStack var2, @Nullable InteractionHand var3);

    @Nullable
    public MobSpawnType getMobSpawnType(Mob var1);

    public Pack.Metadata createPackInfo(ResourceLocation var1, Component var2, PackCompatibility var3, FeatureFlagSet var4, boolean var5);

    public boolean canApplyAtEnchantingTable(Holder<Enchantment> var1, ItemStack var2);

    default public boolean isAllowedOnBooks(Holder<Enchantment> enchantment) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack var1, ItemStack var2);

    public boolean onExplosionStart(Level var1, Explosion var2);
}

