/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.manure_common_fabric.util;

import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.manure_common_fabric.data.Variables;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7924;

public class Util {
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "manure";
    private static final File dir = new File(dirpath);
    private static final File blacklistfile = new File(dirpath + File.separator + "blacklist.txt");
    private static final List<String> defaultBlacklistedNames = Arrays.asList("minecraft:axolotl", "minecraft:bee", "minecraft:frog");
    public static List<class_1299<?>> manureAnimals = new ArrayList();

    public static void attemptBlacklistProcessing(class_1937 level) {
        if (!Variables.processedBlacklist) {
            try {
                Util.loadManureBlacklist(level);
                Variables.processedBlacklist = true;
            }
            catch (Exception ex) {
                System.out.println("[Manure] Error: Unable to generate manure blacklist.");
            }
        }
    }

    public static void loadManureBlacklist(class_1937 level) throws Exception {
        String name;
        class_2378 entityTypeRegistry = level.method_30349().method_30530(class_7924.field_41266);
        ArrayList<String> blacklist = new ArrayList<String>();
        PrintWriter writer = null;
        if (!dir.isDirectory() || !blacklistfile.isFile()) {
            dir.mkdirs();
            if (!blacklistfile.isFile()) {
                writer = new PrintWriter(dirpath + File.separator + "blacklist.txt", StandardCharsets.UTF_8);
            }
        } else {
            String blcontent = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "blacklist.txt", new String[0])));
            for (String entityrl : blcontent.split(",")) {
                name = entityrl.replace("\n", "").trim();
                if (!name.startsWith("!")) continue;
                blacklist.add(name.replace("!", ""));
            }
        }
        ArrayList<String> namesToWrite = new ArrayList<String>();
        for (class_2960 loc : entityTypeRegistry.method_10235()) {
            class_1299 entitytype = (class_1299)entityTypeRegistry.method_10223(loc);
            class_1297 entity = entitytype.method_5883(level);
            if (!(entity instanceof class_1429)) continue;
            name = loc.toString();
            if (writer != null) {
                namesToWrite.add(name);
            }
            if (blacklist.contains(name)) continue;
            manureAnimals.add(entitytype);
        }
        if (writer != null) {
            Collections.sort(namesToWrite);
            for (String name2 : namesToWrite) {
                String prefix = "";
                if (defaultBlacklistedNames.contains(name2)) {
                    blacklist.add(name2);
                    prefix = "!";
                }
                writer.println(prefix + name2 + ",");
            }
            writer.close();
        }
    }
}

