/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.manure_common_neoforge.events;

import com.natamus.manure_common_neoforge.config.ConfigHandler;
import com.natamus.manure_common_neoforge.items.ManureItems;
import com.natamus.manure_common_neoforge.util.Util;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ManureDropEvent {
    private static final CopyOnWriteArrayList<Animal> loadedAnimals = new CopyOnWriteArrayList();

    public static void onServerTick(MinecraftServer server) {
        if (server.getTickCount() % ConfigHandler.manureDropDelayTicks != 0) {
            return;
        }
        for (Animal animal : loadedAnimals) {
            if (!animal.isAlive()) {
                loadedAnimals.remove(animal);
                continue;
            }
            animal.level().addFreshEntity((Entity)new ItemEntity(animal.level(), animal.getX(), animal.getY() + 0.5, animal.getZ(), new ItemStack((ItemLike)ManureItems.MANURE, 1)));
        }
    }

    public static void onEntityJoin(Entity entity, ServerLevel world) {
        if (entity instanceof Animal && Util.manureAnimals.contains(entity.getType())) {
            loadedAnimals.add((Animal)entity);
        }
    }

    public static void onEntityLeave(Entity entity, ServerLevel world) {
        if (entity instanceof Animal) {
            loadedAnimals.remove((Animal)entity);
        }
    }
}

