/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared.common;

import java.util.UUID;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.suppsquared.SuppSquared;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HeavyKeyItem
extends KeyItem {
    public HeavyKeyItem(Item.Properties properties) {
        super(properties);
    }

    public String getPassword(ItemStack stack) {
        this.verifyComponentsAfterLoad(stack);
        return HeavyKeyItem.uuidToLongString((UUID)stack.get(SuppSquared.HEAVY_KEY_UUID.get()));
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (!stack.has(SuppSquared.HEAVY_KEY_UUID.get())) {
            stack.set(SuppSquared.HEAVY_KEY_UUID.get(), (Object)UUID.randomUUID());
        }
    }

    public void onCraftedPostProcess(ItemStack stack, Level level) {
        super.onCraftedPostProcess(stack, level);
        this.verifyComponentsAfterLoad(stack);
    }

    private static String uuidToLongString(UUID id) {
        return id.toString().replace("-", "-----");
    }
}

