/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.common_config.config;

import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.Config;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.file.FileConfig;
import dev.kostromdan.mods.crash_assistant.nightconfig.core.io.ParsingException;
import dev.kostromdan.mods.crash_assistant.nightconfig.json.JsonFormat;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ProblematicModsConfig {
    private static final Path CONFIG_PATH = Paths.get("config", "crash_assistant", "problematic_mods_config.json");

    public static List<ProblematicMod> getProblematicModsFromConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object config = FileConfig.builder(CONFIG_PATH, JsonFormat.fancyInstance()).preserveInsertionOrder().build();
        try {
            config.load();
        }
        catch (ParsingException e) {
            JarInJarHelper.LOGGER.error("Error while loading problematic_mods_config.json, saved old problematic config as 'problematic_mods_config.json.bak', resetting config to default values:", (Throwable)e);
            try {
                CONFIG_PATH.toFile().renameTo(Paths.get(CONFIG_PATH.getParent().toString(), "problematic_mods_config.json.bak").toFile());
            }
            catch (Exception e1) {
                JarInJarHelper.LOGGER.error("Failed to rename 'problematic_mods_config.json' to 'problematic_mods_config.json.bak': ", (Throwable)e1);
            }
            config.clear();
        }
        ProblematicModsConfig.setUpDefaultConfig(config);
        config.save();
        ArrayList<ProblematicMod> problematicMods = new ArrayList<ProblematicMod>();
        for (Map.Entry<String, Object> entry : config.valueMap().entrySet()) {
            String modid = entry.getKey();
            if (modid.equals("example_modid")) continue;
            Object value = entry.getValue();
            if (value instanceof Config) {
                Config modConfig = (Config)value;
                boolean shouldCrash = modConfig.getOrElse("should_crash_on_startup", Boolean.valueOf(false));
                boolean displayButtons = modConfig.getOrElse("display_remove_disable_buttons", Boolean.valueOf(false));
                String msg = modConfig.getOrElse("msg", "");
                problematicMods.add(new ProblematicMod(modid, null, shouldCrash, msg));
                continue;
            }
            JarInJarHelper.LOGGER.warn("Invalid config entry for modid '{}': expected a config object, got {}", (Object)modid, value);
        }
        return problematicMods;
    }

    public static List<ProblematicMod> getCurrentProblematicMods() {
        List<ProblematicMod> problematicMods = ProblematicModsConfig.getProblematicModsFromConfig();
        LinkedHashSet<Mod> currentMods = ModListUtils.getCurrentModList(true);
        Map<String, ProblematicMod> configMap = problematicMods.stream().collect(Collectors.toMap(ProblematicMod::getModid, pm -> pm));
        return currentMods.stream().filter(mod -> configMap.containsKey(mod.getModId())).map(mod -> {
            ProblematicMod fromConfig = (ProblematicMod)configMap.get(mod.getModId());
            return new ProblematicMod(fromConfig.getModid(), (Mod)mod, fromConfig.isShouldCrashOnStartup(), fromConfig.getMsg());
        }).collect(Collectors.toList());
    }

    public static void setUpDefaultConfig(FileConfig config) {
        if (config.isEmpty()) {
            Config exampleModConfig = Config.inMemory();
            exampleModConfig.set("should_crash_on_startup", (Object)true);
            exampleModConfig.set("msg", (Object)"Custom msg on crash for this mod id. You can use $JAR_NAME$ placeholder, which will be replaced with jar name. You can use HTML here, it will work.");
            config.set("example_modid", (Object)exampleModConfig);
        }
    }

    public static void crashIfProblematicMod() {
        List<ProblematicMod> problematicModsFromConfig = ProblematicModsConfig.getProblematicModsFromConfig();
        if (problematicModsFromConfig.stream().noneMatch(ProblematicMod::isShouldCrashOnStartup)) {
            return;
        }
        List<ProblematicMod> problematicMods = ProblematicModsConfig.getCurrentProblematicMods();
        boolean shouldCrash = false;
        for (ProblematicMod mod : problematicMods) {
            if (!mod.isShouldCrashOnStartup()) continue;
            shouldCrash = true;
            Mod currentMod = mod.getCurrentMod();
            JarInJarHelper.LOGGER.error("Detected " + currentMod.getJarName() + "(modId: " + mod.getModid() + ") in current modlist.\nIt marked as incompatible with this modpack(" + String.valueOf(CONFIG_PATH) + ").\nCrashing game and starting Crash Assistant.\nMessage from modpack creators:\n" + mod.getMsg());
        }
        if (shouldCrash) {
            ProcessHelper.exitProcess(-1);
        }
    }

    public static class ProblematicMod {
        private final String modid;
        private final Mod currentMod;
        private final boolean shouldCrashOnStartup;
        private final String msg;

        public ProblematicMod(String modid, Mod currentMod, boolean shouldCrashOnStartup, String msg) {
            this.modid = modid;
            this.currentMod = currentMod;
            this.shouldCrashOnStartup = shouldCrashOnStartup;
            this.msg = msg;
        }

        public String getModid() {
            return this.modid;
        }

        public Mod getCurrentMod() {
            return this.currentMod;
        }

        public boolean isShouldCrashOnStartup() {
            return this.shouldCrashOnStartup;
        }

        public String getMsg() {
            return this.msg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblematicMod that = (ProblematicMod)o;
            return this.shouldCrashOnStartup == that.shouldCrashOnStartup && Objects.equals(this.modid, that.modid) && Objects.equals(this.currentMod, that.currentMod) && Objects.equals(this.msg, that.msg);
        }

        public int hashCode() {
            return Objects.hash(this.modid, this.currentMod, this.shouldCrashOnStartup, this.msg);
        }

        public String toString() {
            return "ProblematicMod{modid='" + this.modid + "', currentMod=" + String.valueOf(this.currentMod) + ", shouldCrashOnStartup=" + this.shouldCrashOnStartup + ", msg='" + this.msg + "'}";
        }
    }
}

