/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.tiles.RepaintableBlockTile;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.blocks.Pipe;
import com.endertech.minecraft.mods.adchimneys.blocks.Vent;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Pump
extends Container
implements ITiledBlock<Tile> {
    public static ModConfigSpec.ConfigValue<Boolean> invertedRedstoneSignal;
    public static ModConfigSpec.ConfigValue<Boolean> energyStorageEnabled;
    public static ModConfigSpec.ConfigValue<Integer> energyStorageCapacity;
    public static ModConfigSpec.ConfigValue<Integer> energyStorageConsumption;
    protected static final VoxelShape HOLES_TOP;
    protected static final VoxelShape SUPPORTS_VERT;
    protected static final VoxelShape SHAPE;
    protected static final VoxelShape SUPPORT_SHAPE;

    public Pump(Container.Properties<?> props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.LIT});
    }

    public Tile createTile(BlockPos pos, BlockState state) {
        return new Tile(pos, state);
    }

    public Class<Tile> getTileClass() {
        return Tile.class;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isActive(BlockGetter level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)BlockStateProperties.LIT);
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return level.getMaxLightLevel() * 2 / 3;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public boolean updateLitState(ServerLevel level, BlockPos pos, BlockState state, boolean lit) {
        if ((Boolean)state.getValue((Property)BlockStateProperties.LIT) != lit) {
            return level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(lit)));
        }
        return false;
    }

    public List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, BlockPos pos) {
        return this.getTile((BlockGetter)level, pos).map(tile -> tile.getClosestActiveExhaustPumps(level, pos)).orElse(Collections.emptyList());
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.PUMP;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.isActive((BlockGetter)level, pos)) {
            this.spawnActiveStateParticles(level, pos);
        }
    }

    protected void spawnActiveStateParticles(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos)) continue;
            Function<Direction.Axis, Double> delta = axis -> direction.getAxis() == axis ? 0.5 + 0.5625 * (double)direction.getNormal().get(axis) : level.getRandom().nextDouble();
            level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)pos.getX() + delta.apply(Direction.Axis.X), (double)pos.getY() + delta.apply(Direction.Axis.Y), (double)pos.getZ() + delta.apply(Direction.Axis.Z), 0.0, 0.0, 0.0);
        }
    }

    static {
        HOLES_TOP = Shapes.or((VoxelShape)Pump.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Pump.box((double)3.0, (double)13.0, (double)10.0, (double)13.0, (double)16.0, (double)13.0), Pump.box((double)3.0, (double)13.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0), Pump.box((double)10.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)});
        SUPPORTS_VERT = Shapes.or((VoxelShape)Pump.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]);
        VoxelShape hopper = Shapes.or((VoxelShape)Pump.box((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Pump.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Pump.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
        VoxelShape shape = Shapes.joinUnoptimized((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)Vent.HOLE_CENTER, (VoxelShape[])new VoxelShape[]{Vent.HOLES_X, Vent.HOLES_Z, Vent.HOLES_BOTTOM, HOLES_TOP}), (BooleanOp)BooleanOp.ONLY_FIRST);
        SHAPE = Shapes.or((VoxelShape)shape, (VoxelShape)Pipe.SHAPE);
        SUPPORT_SHAPE = Shapes.or((VoxelShape)SHAPE, (VoxelShape[])new VoxelShape[]{Vent.SUPPORTS_SIDE, SUPPORTS_VERT});
    }

    public static class Tile
    extends RepaintableBlockTile
    implements ITickableUnit {
        private final GameTime updateInterval = GameTime.second();
        private final HopperAnimation hopperAnimation = new HopperAnimation();
        protected final ForgeEnergy.Storage energyStorage;
        protected List<BlockPos> closestActiveExhaustPumps = null;
        protected boolean active = false;

        public static ForgeEnergy.Storage getEnergy(Tile tile, @Nullable Direction side) {
            return tile.energyStorage.isEnabled() ? tile.energyStorage : null;
        }

        public Tile(BlockPos pos, BlockState state) {
            super((BlockEntityType)AdChimneys.getInstance().tiles.pump.get(), pos, state);
            ForgeEnergy.StorageProps props = ForgeEnergy.StorageProps.create((boolean)((Boolean)energyStorageEnabled.get()), (int)((Integer)energyStorageCapacity.get()), (int)((Integer)energyStorageConsumption.get()));
            this.energyStorage = ForgeEnergy.Storage.with((ForgeEnergy.StorageProps)props);
        }

        protected Optional<BlockPos> getHopperInput() {
            BlockPos pos;
            Level level = this.getWorldLevel();
            if (level != null && (pos = (BlockPos)GameWorld.SmokeContainers.getConnectedHopper((LevelReader)level, (BlockPos)this.getBlockPos()).orElse(null)) != null) {
                if (GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)(pos = pos.above()))) {
                    pos = GameWorld.SmokeContainers.getTopmostChimney((LevelReader)level, (BlockPos)pos).above();
                }
                return Optional.of(pos);
            }
            return Optional.empty();
        }

        @Nullable
        public Level getWorldLevel() {
            return this.getLevel();
        }

        protected boolean updateActiveState() {
            Level level = this.getWorldLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                BlockPos pos = this.getBlockPos();
                boolean powered = level2.hasNeighborSignal(pos);
                if (((Boolean)invertedRedstoneSignal.get()).booleanValue()) {
                    boolean bl = powered = !powered;
                }
                if (this.energyStorage.isEnabled() && !this.energyStorage.hasEnoughEnergy()) {
                    powered = false;
                }
                if (powered != this.active) {
                    this.active = powered;
                    BlockState state = level2.getBlockState(pos);
                    Block block = state.getBlock();
                    if (block instanceof Pump) {
                        Pump pump = (Pump)block;
                        pump.updateLitState(level2, pos, state, this.active);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean exists() {
            return !this.isRemoved();
        }

        public GameTime getUpdateInterval() {
            return this.updateInterval;
        }

        public void tick() {
            if (Optional.ofNullable(this.getWorldLevel()).filter(Level::isClientSide).isPresent()) {
                this.getHopperAnimation().tick();
            }
            super.tick();
        }

        public void onUpdate() {
            Level level = this.getWorldLevel();
            if (level == null) {
                return;
            }
            if (level.isClientSide()) {
                this.getHopperAnimation().updateState(this.isActive(), GameWorld.SmokeContainers.isReversedPump((LevelReader)level, (BlockPos)this.getBlockPos()));
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean needSync = this.updateActiveState();
                if (this.isActive()) {
                    Optional<BlockPos> inputPos;
                    if (this.energyStorage.consumeEnergy() > 0) {
                        needSync = true;
                    }
                    if (this.getUpdateInterval().mult(2).pastIn((Level)serverLevel)) {
                        this.closestActiveExhaustPumps = null;
                        this.getClosestActiveExhaustPumps((LevelAccessor)serverLevel, this.getBlockPos());
                    }
                    if ((inputPos = this.getHopperInput()).isPresent()) {
                        BlockPos pos = inputPos.get();
                        if (GameWorld.SmokeContainers.isVent((LevelReader)serverLevel, (BlockPos)pos)) {
                            WorldSearch.VentPipe.suck((LevelAccessor)serverLevel, (BlockPos)pos, (BlockPos)this.getBlockPos());
                        } else if (this.getUpdateInterval().mult(3).pastIn((Level)serverLevel)) {
                            this.suckPollutionViaHopper(pos);
                        }
                    } else {
                        WorldSearch.VentPipe.suck((LevelAccessor)serverLevel, (BlockPos)this.getBlockPos());
                    }
                }
                if (needSync) {
                    this.syncWithClients();
                }
            }
        }

        public HopperAnimation getHopperAnimation() {
            return this.hopperAnimation;
        }

        protected List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, BlockPos pos) {
            if (this.closestActiveExhaustPumps == null) {
                List pumps = GameWorld.SmokeContainers.getClosestActiveExhaustPumps((LevelAccessor)level, (BlockPos)pos);
                this.closestActiveExhaustPumps = Collections.unmodifiableList(pumps);
            }
            return this.closestActiveExhaustPumps;
        }

        protected void suckPollutionViaHopper(BlockPos inputPos) {
            Level level = this.getWorldLevel();
            if (level == null || level.isClientSide()) {
                return;
            }
            if (level.getBlockState(inputPos).isFaceSturdy((BlockGetter)level, inputPos, Direction.DOWN)) {
                return;
            }
            IntBounds height = IntBounds.between((Integer)inputPos.getY(), (Integer)(inputPos.getY() + 2));
            int maxRadius = GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)inputPos.below()) ? 1 : GameWorld.SmokeContainers.getHopperSuctionRange((LevelReader)level, (BlockPos)inputPos.below());
            final BlockPos pumpPos = this.getBlockPos();
            WorldSearch.VertCylinder searcher = new WorldSearch.VertCylinder(this, (LevelAccessor)level, inputPos, height, maxRadius){

                protected boolean isValidPath(BlockPos pos) {
                    if (this.level.isEmptyBlock(pos)) {
                        return true;
                    }
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    BlockPos last = pos.relative(this.lastUsedDirection.getOpposite());
                    return !this.level.getBlockState(last).isFaceSturdy((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.getBlockState(pos).isFaceSturdy((BlockGetter)this.level, pos, this.lastUsedDirection.getOpposite());
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.level.getBlockState(pos).getBlock() instanceof IPollutant;
                }

                protected boolean onValidFound(BlockPos pos) {
                    Block block = this.level.getBlockState(pos).getBlock();
                    if (block instanceof IPollutant) {
                        IPollutant pollutant = (IPollutant)block;
                        int count = GameWorld.SmokeContainers.pumpPollutionThrough(List.of(pumpPos), (LevelAccessor)this.level, (IPollutant)pollutant, (int)1);
                        if (count > 0) {
                            pollutant.spend(this.level, pos, count);
                        }
                    }
                    return false;
                }
            };
            searcher.build();
        }

        public void readSharedData(CompoundTag compound, HolderLookup.Provider registries) {
            super.readSharedData(compound, registries);
            this.active = compound.getBoolean("active");
            this.energyStorage.readFrom(compound);
        }

        public CompoundTag writeSharedData(CompoundTag compound, HolderLookup.Provider registries) {
            super.writeSharedData(compound, registries);
            compound.putBoolean("active", this.active);
            this.energyStorage.writeTo(compound);
            return compound;
        }
    }

    public static class HopperAnimation {
        public final FloatBounds valueRange = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f));
        public final FloatBounds speedRange = FloatBounds.between((Float)Float.valueOf(0.01f), (Float)Float.valueOf(0.3f));
        public final IntBounds pauseRange = IntBounds.between((Integer)5, (Integer)50);
        protected boolean enabled = false;
        protected boolean reversed = false;
        protected float value = this.valueRange.getMax().floatValue();
        protected float speed = this.speedRange.getMin().floatValue();
        protected int pause = this.pauseRange.getMin();

        public void updateState(boolean enabled, boolean reversed) {
            this.enabled = enabled;
            this.reversed = reversed;
            this.updateSpeed();
        }

        public float getValue(float partialTicks) {
            return this.enabled && this.pause == 0 ? this.valueRange.enclose(Float.valueOf(this.value + this.speed * partialTicks)).floatValue() : this.value;
        }

        protected void updateSpeed() {
            if (this.speed > 0.0f) {
                this.speed = (this.reversed ? this.speedRange.getMin() : this.speedRange.getMax()).floatValue();
            }
            if (this.speed < 0.0f) {
                this.speed = this.reversed ? -this.speedRange.getMax().floatValue() : -this.speedRange.getMin().floatValue();
            }
        }

        public void tick() {
            if (!this.enabled) {
                return;
            }
            if (this.pause > 0) {
                --this.pause;
                return;
            }
            this.value += this.speed;
            if (!this.valueRange.encloses(Float.valueOf(this.value))) {
                this.speed = -this.speed;
                this.updateSpeed();
                if (this.speed > 0.0f) {
                    this.pause = this.reversed ? this.pauseRange.randomBetween() : this.pauseRange.getMin();
                }
                if (this.speed < 0.0f) {
                    this.pause = this.reversed ? this.pauseRange.getMin() : this.pauseRange.randomBetween();
                }
                this.value = this.valueRange.enclose(Float.valueOf(this.value)).floatValue();
            }
        }
    }

    public static class Properties<T extends Properties<T>>
    extends Container.Properties<T> {
        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        public T litStateEmission(int lightLevel) {
            this.vanillaProps.lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightLevel : 0);
            return (T)((Object)((Properties)this.self));
        }
    }
}

