/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.client;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.mods.adchimneys.blocks.Pump;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.Lazy;

@OnlyIn(value=Dist.CLIENT)
public class PumpRenderer
implements BlockEntityRenderer<Pump.Tile> {
    protected final Lazy<ItemStack> vanillaCogwheel = Lazy.of(() -> new ItemStack((ItemLike)Items.SPRUCE_FENCE));
    protected final Lazy<ItemStack> createCogwheel = Lazy.of(() -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"cogwheel"))));

    public PumpRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(Pump.Tile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = tile.getLevel();
        RenderType renderType = RenderType.cutoutMipped();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        BlockPos pos = tile.getBlockPos();
        float progress = tile.getHopperAnimation().getValue(partialTicks);
        if (level != null) {
            this.renderHopper(level, pos, progress, poseStack, vertexConsumer);
            this.renderCogwheel(level, pos, progress, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    protected void renderHopper(Level level, BlockPos pos, float progress, PoseStack poseStack, VertexConsumer vertexConsumer) {
        float offset = 0.1875f;
        float scale = 0.625f;
        float scaleY = FloatBounds.between((Float)Float.valueOf(0.5f), (Float)Float.valueOf(0.875f)).interpolateUp(progress).floatValue();
        poseStack.pushPose();
        poseStack.translate(offset, 0.01f, offset);
        poseStack.scale(scale, scaleY, scale);
        this.renderBlock(level, Blocks.HOPPER.defaultBlockState(), pos, poseStack, vertexConsumer);
        poseStack.popPose();
    }

    protected void renderCogwheel(Level level, BlockPos pos, float progress, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float offset = 0.25f;
        float dy = 0.001f;
        float scale = 1.0f;
        float rotationY = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(360.0f)).interpolateUp(progress).floatValue();
        boolean vanilla = ((ItemStack)this.createCogwheel.get()).isEmpty();
        ItemStack cogwheelItem = vanilla ? (ItemStack)this.vanillaCogwheel.get() : (ItemStack)this.createCogwheel.get();
        for (int i = 0; i < (vanilla ? 3 : 1); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.5f, offset + dy * (float)(i + 1), 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotationY + 120.0f * (float)i));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.scale(scale, scale, scale);
            this.renderItem(level, cogwheelItem, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }

    protected void renderBlock(Level level, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer vertexConsumer) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, dispatcher.getBlockModel(state), state, pos, poseStack, vertexConsumer, false, RandomSource.create(), state.getSeed(pos), OverlayTexture.NO_OVERLAY);
    }

    protected void renderItem(Level level, ItemStack itemStack, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, level, 0);
    }
}

