/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.mixin;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"io.github.mortuusars.sootychimneys.block.ChimneyBlock"})
public abstract class SootyChimneyBlockMixin
extends Block {
    public SootyChimneyBlockMixin(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"emitSmokeParticles"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void emitParticles(Level level, BlockState state, double x, double y, double z, boolean signalSmoke, CallbackInfo callback) {
        if (this.shouldDisableParticles(level, x, y, z)) {
            callback.cancel();
        }
    }

    @Inject(method={"emitParticle"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void emitParticle(Level level, double x, double y, double z, ParticleOptions options, CallbackInfo callback) {
        if (this.shouldDisableParticles(level, x, y, z)) {
            callback.cancel();
        }
    }

    @Unique
    private boolean shouldDisableParticles(Level level, double x, double y, double z) {
        BlockPos startPos = BlockPos.containing((double)x, (double)y, (double)z).above();
        BlockPos.MutableBlockPos pos = startPos.mutable();
        while (level.isInWorldBounds((BlockPos)pos)) {
            BlockState state = level.getBlockState((BlockPos)pos);
            if (state.getBlock() instanceof ISmokeContainer) {
                return true;
            }
            if (AdChimneys.getInstance().emitters.get(state).isPresent()) {
                return true;
            }
            if (!pos.equals((Object)startPos) && !state.is(GameWorld.SmokeContainers.CHIMNEYS)) break;
            pos.move(Direction.DOWN);
        }
        return false;
    }
}

