/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.mods.adchimneys.network.SmokePoisonEffectMsg;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AbstractSmokeParticle {

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Instance
    extends TextureSheetParticle {
        protected static final int MAX_HIT_AFTER_HIT_AMOUNT = 2;
        protected static final double ON_HIT_MOTION_REDICTION = 0.3;
        protected static final double MIN_BOUNCE_MOTION = 0.1;
        protected boolean insideChimney = true;
        protected float chimneySize = 0.0f;
        protected int ticksInChimney = 0;
        protected int ignoreWindDelay = 0;
        protected long lastUpdateTime;
        protected final IWind wind;
        protected final SpriteSet animatedSprite;
        protected final BlockPos startPos;
        protected final GameTime poisonEffectUpdateInterval = GameTime.second();
        private int hitAfterHitCount = 0;

        public Instance(ClientLevel level, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, SpriteSet sprite) {
            super(level, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
            this.animatedSprite = sprite;
            this.wind = wind;
            this.setSpriteFromAge(sprite);
            this.hasPhysics = (Boolean)Smoke.canCollide.get();
            this.lastUpdateTime = level.getGameTime();
            this.startPos = this.getBlockPos();
            WorldData.getData((LevelAccessor)level).getSmokeLocations().countSmokeParticle(this);
        }

        public abstract void updateAnimatedSprite();

        public Vect3d getPosition() {
            return Vect3d.from((double)this.x, (double)this.y, (double)this.z);
        }

        public Vect3d getMotion() {
            return Vect3d.from((double)this.xd, (double)this.yd, (double)this.zd);
        }

        public void setMotion(Vect3d motion) {
            this.xd = motion.x;
            this.yd = motion.y;
            this.zd = motion.z;
        }

        public void setColor(ColorARGB color) {
            this.setColor(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public void setPosition(Vect3d pos) {
            this.setPos(pos.x, pos.y, pos.z);
        }

        public BlockPos getBlockPos() {
            return BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        }

        protected void tryColorizeWith(ColorARGB color) {
            if (Smoke.colorize == null || !((Boolean)Smoke.colorize.get()).booleanValue()) {
                return;
            }
            float alpha = color.getAlpha().toFloat();
            if (CommonMath.Random.result((float)(alpha * ((Double)Smoke.coloringFactor.get()).floatValue()))) {
                this.setColor(color);
            }
        }

        public boolean isAlive() {
            return super.isAlive() && Mth.abs((float)(this.level.getGameTime() - this.lastUpdateTime)) <= (float)this.lifetime;
        }

        public void tick() {
            this.lastUpdateTime = this.level.getGameTime();
            ++this.age;
            if (this.age >= this.lifetime) {
                this.remove();
            }
            BlockPos blockPos = this.getBlockPos();
            BlockState state = this.level.getBlockState(blockPos);
            if (GameWorld.SmokeContainers.isChimney((LevelReader)this.level, (BlockPos)blockPos)) {
                VoxelShape shape = state.getCollisionShape((BlockGetter)this.level, blockPos);
                if (!shape.isEmpty()) {
                    AABB bb = shape.bounds();
                    this.insideChimney = bb.move(blockPos).contains(this.x, this.y, this.z);
                    this.chimneySize = (float)Math.min(bb.getXsize(), bb.getZsize());
                } else {
                    this.insideChimney = false;
                    this.chimneySize = 1.0f;
                }
            } else {
                this.insideChimney = false;
            }
            if (this.insideChimney && CommonMath.notZero((double)this.yd) && this.yd > 0.0) {
                ++this.ticksInChimney;
                --this.age;
            }
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.updateAnimatedSprite();
            this.updatePoisonEffect();
            if (this.ignoreWindDelay > 0) {
                --this.ignoreWindDelay;
            }
            boolean affectedByWind = false;
            if (!this.insideChimney && this.ignoreWindDelay <= 0) {
                for (Direction direction : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
                    BlockPos pos = blockPos.relative(direction);
                    if (state.isFaceSturdy((BlockGetter)this.level, blockPos, direction) || !this.level.hasChunkAt(pos) || !this.hasNoBlocksAbove(pos)) continue;
                    affectedByWind = true;
                    break;
                }
            }
            if (this.yd < 0.01 && this.ignoreWindDelay <= 0 && this.hasNoBlocksAbove(blockPos)) {
                this.yd = 0.1;
            }
            if (!this.insideChimney) {
                this.yd -= (double)this.gravity;
            }
            if (affectedByWind) {
                this.xd = this.wind.getMotion().x;
                this.zd = this.wind.getMotion().z;
            } else if (!this.insideChimney) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
            this.move(this.xd, this.yd, this.zd);
        }

        public boolean hasNoBlocksAbove(BlockPos pos) {
            return this.level.canSeeSky(pos) && this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() <= pos.getY();
        }

        public void move(double dx, double dy, double dz) {
            this.move(Vect3d.from((double)dx, (double)dy, (double)dz));
        }

        public void move(Vect3d motion) {
            Vect3d nextPos = this.getPosition().add(motion);
            this.moveTo(nextPos);
        }

        private void moveTo(Vect3d nextPos) {
            if (this.hasPhysics) {
                if (this.hitAfterHitCount > 2) {
                    this.remove();
                    return;
                }
                Vect3d curPos = this.getPosition();
                BlockPos blockPos = nextPos.toBlockPos();
                if (!blockPos.equals((Object)this.getBlockPos()) && !GameWorld.isBlockLoaded((LevelReader)this.level, (BlockPos)blockPos)) {
                    this.remove();
                    return;
                }
                BlockState blockState = this.level.getBlockState(blockPos);
                BlockHitResult hit = blockState.getCollisionShape((BlockGetter)this.level, blockPos).clip(curPos.toVector3d(), nextPos.toVector3d(), blockPos);
                if (this.startPos.equals((Object)this.getBlockPos())) {
                    hit = null;
                }
                if (hit != null && !blockState.isFaceSturdy((BlockGetter)this.level, blockPos, hit.getDirection())) {
                    hit = null;
                }
                if (hit != null && hit.getDirection().equals((Object)Direction.DOWN) && GameWorld.SmokeContainers.isChimney((LevelReader)this.level, (BlockPos)blockPos)) {
                    hit = null;
                }
                if (hit != null && hit.getType() != HitResult.Type.MISS) {
                    ++this.hitAfterHitCount;
                    this.ignoreWindDelay = IntBounds.between((Integer)5, (Integer)15).randomBetween();
                    Direction.Axis axis = hit.getDirection().getAxis();
                    Vect3d hitLocation = Vect3d.from((Vec3)hit.getLocation());
                    Vect3d bounceVec = nextPos.subtract(hitLocation);
                    double reduction = 0.3;
                    switch (axis) {
                        case X: {
                            bounceVec = bounceVec.invertX();
                            this.xd = -this.xd * reduction;
                            break;
                        }
                        case Z: {
                            bounceVec = bounceVec.invertZ();
                            this.zd = -this.zd * reduction;
                            break;
                        }
                        case Y: {
                            bounceVec = bounceVec.invertY();
                            if (CommonMath.isAlmostZero((double)(this.xd * this.xd + this.zd * this.zd))) {
                                CommonMath.Angle angle = CommonMath.Angle.random();
                                double motion = Math.max(this.yd * reduction, 0.1);
                                this.xd = angle.cos() * motion;
                                this.zd = angle.sin() * motion;
                            }
                            this.yd = -this.yd * reduction;
                            break;
                        }
                        default: {
                            this.remove();
                            return;
                        }
                    }
                    nextPos = hitLocation.add(bounceVec);
                    this.moveTo(nextPos);
                    return;
                }
            }
            this.hitAfterHitCount = 0;
            this.setPosition(nextPos);
        }

        public abstract ParticleRenderType getRenderType();

        protected void updatePoisonEffect() {
            if (this.poisonEffectUpdateInterval.pastIn((Level)this.level)) {
                AABB aabb = this.insideChimney ? this.getBoundingBox().setMinY((double)GameWorld.SmokeContainers.getBottommostChimney((LevelReader)this.level, (BlockPos)this.getBlockPos()).getY()) : this.getBoundingBox().inflate(0.5);
                this.level.getEntitiesOfClass(LivingEntity.class, aabb, entity -> entity.isAlive() && aabb.contains(entity.getEyePosition())).forEach(living -> new SmokePoisonEffectMsg((LivingEntity)living).sendToServer());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Provider<T extends Options>
    implements ParticleProvider<T> {
        protected final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public abstract Particle createParticle(T var1, ClientLevel var2, double var3, double var5, double var7, double var9, double var11, double var13);
    }

    public static abstract class Options
    implements ParticleOptions {
        public final IWind wind;
        public final Smoke smoke;

        public Options(IWind wind, Smoke smoke) {
            this.wind = wind;
            this.smoke = smoke;
        }

        public static <T extends Options> ParticleType<T> simpleParticleType(T options) {
            final MapCodec codec = MapCodec.unit(options);
            final StreamCodec streamCodec = StreamCodec.unit(options);
            return new ParticleType<T>(true){

                public MapCodec<T> codec() {
                    return codec;
                }

                public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                    return streamCodec;
                }
            };
        }
    }
}

