/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mrbysco.spoiled.Constants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class SpoiledCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"spoiled");
        ((LiteralArgumentBuilder)root.requires(commandSource -> commandSource.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").then(Commands.literal((String)"blockentity").executes(SpoiledCommands::listBlockEntities))).then(Commands.literal((String)"food").executes(SpoiledCommands::listFood)));
        dispatcher.register(root);
    }

    private static int listBlockEntities(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> Component.translatable((String)"spoiled.command.blockentity_list.message").withStyle(ChatFormatting.YELLOW), true);
        ArrayList keys = new ArrayList(BuiltInRegistries.BLOCK_ENTITY_TYPE.keySet());
        Constants.LOGGER.info("List of Block Entities requested by " + source.getTextName() + ":");
        keys.forEach(t -> Constants.LOGGER.info(t.toString()));
        return 0;
    }

    private static int listFood(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> Component.translatable((String)"spoiled.command.food_list.message").withStyle(ChatFormatting.YELLOW), true);
        List<Item> foodItems = BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().has(DataComponents.FOOD)).toList();
        List<ResourceLocation> keys = foodItems.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).toList();
        Constants.LOGGER.info("List of Foods requested by " + source.getTextName() + ":");
        keys.forEach(t -> Constants.LOGGER.info(t.toString()));
        return 0;
    }
}

