/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.ct;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.mrbysco.spoiled.platform.Services;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.registration.SpoiledRecipes;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.spoiled.SpoilingManager")
public class SpoilManager
implements IRecipeManager<SpoilRecipe> {
    @ZenCodeType.Method
    public void addSpoiling(String name, IIngredient food, IItemStack spoilStack, int spoilTime) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)name);
        Ingredient foodIngredient = food.asVanillaIngredient();
        ItemStack resultItemStack = spoilStack.getInternal();
        SpoilRecipe recipe = new SpoilRecipe("", foodIngredient, resultItemStack, spoilTime);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void addModSpoiling(String modName, IItemStack spoilStack, int spoilTime) {
        if (Services.PLATFORM.isModLoaded(modName)) {
            List<Item> edibleFoodList = BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().has(DataComponents.FOOD)).toList();
            for (Item foundItem : edibleFoodList) {
                ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)foundItem);
                if (foundItem == spoilStack.getInternal().getItem() || location == null || !location.getNamespace().equals(modName)) continue;
                String itemLocation = location.toString().replace(":", "_");
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)itemLocation);
                SpoilRecipe recipe = new SpoilRecipe("", Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)foundItem)}), spoilStack.getInternal(), spoilTime);
                CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
            }
        }
    }

    public RecipeType<SpoilRecipe> getRecipeType() {
        return SpoiledRecipes.SPOIL_RECIPE_TYPE.get();
    }
}

