/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.curios;

import com.mrbysco.spoiled.config.SpoiledConfigCache;
import com.mrbysco.spoiled.handler.SpoilHandler;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.util.SpoilHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosCompat {
    public static void onCuriosTick(PlayerTickEvent.Post event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).level().getGameTime() % SpoiledConfigCache.spoilRate == 0L && !player.getAbilities().instabuild) {
            Level level = player.level();
            ICuriosItemHandler curiosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null);
            if (curiosItemHandler == null) {
                return;
            }
            IItemHandlerModifiable equipped = curiosItemHandler.getEquippedCurios();
            int slots = equipped.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = equipped.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
                if (itemHandler != null) {
                    if (itemHandler.getSlots() <= 0) continue;
                    for (int j = 0; j < itemHandler.getSlots(); ++j) {
                        RecipeHolder<SpoilRecipe> recipeHolder;
                        ItemStack nestedStack = itemHandler.getStackInSlot(j);
                        if (nestedStack == null || nestedStack.isEmpty() || (recipeHolder = SpoilHelper.getSpoilRecipe(level, nestedStack)) == null) continue;
                        SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
                        SpoilHelper.updateSpoilingStack(nestedStack, recipe);
                        if (!SpoilHelper.isSpoiled(nestedStack)) continue;
                        SpoilHandler.spoilItemInHandler(itemHandler, j, nestedStack, recipe, level.registryAccess());
                    }
                    continue;
                }
                RecipeHolder<SpoilRecipe> recipeHolder = SpoilHelper.getSpoilRecipe(level, stack);
                if (recipeHolder == null) continue;
                SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
                SpoilHelper.updateSpoilingStack(stack, recipe);
                if (!SpoilHelper.isSpoiled(stack)) continue;
                SpoilHelper.spoilItemForPlayer((Player)player, stack, recipe);
            }
        }
    }
}

