/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.jei;

import com.google.common.collect.Lists;
import com.mrbysco.spoiled.Constants;
import com.mrbysco.spoiled.compat.jei.category.SpoilCategory;
import com.mrbysco.spoiled.compat.jei.validator.SpoiledValidator;
import com.mrbysco.spoiled.platform.Services;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.registration.SpoiledRecipes;
import com.mrbysco.spoiled.util.SpoilHelper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = Constants.modLoc("main");
    public static final ResourceLocation SPOILING = Constants.modLoc("spoiling");
    @Nullable
    private IRecipeCategory<SpoilRecipe> spoilCategory;

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.ROTTEN_FLESH), new RecipeType[]{SpoilCategory.TYPE});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.spoilCategory = new SpoilCategory(guiHelper);
        iRecipeCategoryArray[0] = this.spoilCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (this.spoilCategory != null);
        registration.addRecipes(SpoilCategory.TYPE, this.getSpoilRecipes(this.spoilCategory).stream().map(RecipeHolder::value).toList());
    }

    public List<RecipeHolder<SpoilRecipe>> getSpoilRecipes(IRecipeCategory<SpoilRecipe> spoilCategory) {
        ClientLevel level = Minecraft.getInstance().level;
        if (Services.PLATFORM.spoilEverything()) {
            ArrayList recipes = Lists.newArrayList();
            BuiltInRegistries.ITEM.forEach(item -> {
                RecipeHolder<SpoilRecipe> recipeHolder = SpoilHelper.getSpoilRecipe((Level)level, new ItemStack((ItemLike)item));
                if (recipeHolder != null) {
                    recipes.add(recipeHolder);
                }
            });
            return recipes;
        }
        return JEICompat.getValidHandledRecipes(level.getRecipeManager(), new SpoiledValidator(spoilCategory));
    }

    private static List<RecipeHolder<SpoilRecipe>> getValidHandledRecipes(RecipeManager recipeManager, SpoiledValidator validator) {
        return recipeManager.getAllRecipesFor(SpoiledRecipes.SPOIL_RECIPE_TYPE.get()).stream().filter(r -> validator.isRecipeValid((RecipeHolder<SpoilRecipe>)r) && validator.isRecipeHandled((RecipeHolder<SpoilRecipe>)r)).toList();
    }
}

